# TrenchBroom

TrenchBroom is a modern cross-platform level editor for Quake-engine based games.

- Website:   http://kristianduske.com/trenchbroom
- Discord:   https://discord.gg/n7K8Cps
- Tutorial:  https://www.youtube.com/watch?v=gONePWocbqA

[![Build Status](https://travis-ci.org/kduske/TrenchBroom.svg?branch=release%2Fv2.0.0)](https://travis-ci.org/kduske/TrenchBroom) [![Build status](https://ci.appveyor.com/api/projects/status/github/kduske/trenchbroom?branch=release%2Fv2.0.0&svg=true)](https://ci.appveyor.com/project/kduske/trenchbroom/branch/release/v2.0.0)

## Features
* **General**
	- Full support for editing in 3D and in up to three 2D views
	- High performance renderer with support for huge maps
	- Unlimited Undo and Redo
	- Macro-like command repetition
	- Issue browser with automatic quick fixes
	- Point file support
	- Automatic backups
	- Free and cross platform
* **Brush Editing**
	- Robust vertex editing with edge and face splitting and manipulating multiple vertices together
	- Clipping tool with two and three points
	- CSG operations: merge, subtract, intersect
	- UV view for easy texture manipulations
	- Precise texture lock for all brush editing operations
	- Multiple texture collections
* **Entity Editing**
	- Entity browser with drag and drop support
	- Support for FGD and DEF files for entity definitions
	- Mod support
	- Entity link visualization
	- Displays 3D models in the editor
	- Smart entity property editors

## Releases
- Binary builds are available from [releases](https://github.com/kduske/TrenchBroom/releases).

## Compiling
- Read [Build.md](Build.md) for instructions

# Contributing
- Bug reports and feature suggestions are welcome. Please submit them at https://github.com/kduske/TrenchBroom/issues
- If you wish to contribute code or improve the documentation, please get in touch with me at kristian.duske@gmail.com.
- All help is appreciated!

# Credits
- wxWidgets www.wxwidgets.org
- FreeType www.freetype.org
- FreeImage www.freeimage.org
- GLEW glew.sourceforge.net
- GoogleTest code.google.com/p/googletest/
- GoogleMock code.google.com/p/googlemock/
- CMake www.cmake.org
- Pandoc www.pandoc.org
- Quake icons by Th3 ProphetMan th3-prophetman.deviantart.com
- Hexen 2 icon by thedoctor45 thedoctor45.deviantart.com
- Source Sans Pro font www.google.com/fonts/specimen/Source+Sans+Pro

## Changes
See [releases](https://github.com/kduske/TrenchBroom/releases) for latest changes.
