MACRO(SET_XCODE_ATTRIBUTES TARGET)
	# Set Debug information format
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_DEBUG_INFORMATION_FORMAT[variant=Debug] "dwarf")
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_DEBUG_INFORMATION_FORMAT[variant=Release] "dwarf-with-dsym")
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_DEBUG_INFORMATION_FORMAT[variant=RelWithDebInfo] "dwarf-with-dsym")
    # Set some warnings
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_GCC_WARN_PEDANTIC YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_GCC_WARN_64_TO_32_BIT_CONVERSION YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_GCC_WARN_ABOUT_RETURN_TYPE YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_GCC_WARN_SIGN_COMPARE YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_GCC_WARN_UNINITIALIZED_AUTOS YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_GCC_WARN_UNUSED_FUNCTION YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_GCC_WARN_UNUSED_VARIABLE YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_GCC_WARN_NON_VIRTUAL_DESTRUCTOR YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_GCC_WARN_UNDECLARED_SELECTOR YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_GCC_WARN_CHECK_SWITCH_STATEMENTS YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_GCC_WARN_SHADOW YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_GCC_WARN_INITIALIZER_NOT_FULLY_BRACKETED YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_GCC_WARN_MISSING_PARENTHESES YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_GCC_WARN_ABOUT_MISSING_FIELD_INITIALIZERS YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_GCC_WARN_ABOUT_MISSING_NEWLINE YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_GCC_WARN_ABOUT_POINTER_SIGNEDNESS YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_GCC_WARN_UNKNOWN_PRAGMAS YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_GCC_WARN_UNUSED_LABEL YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_GCC_WARN_UNUSED_VALUE YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_GCC_WARN_HIDDEN_VIRTUAL_FUNCTIONS YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_GCC_TREAT_INCOMPATIBLE_POINTER_TYPE_WARNINGS_AS_ERRORS YES)

    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_CLANG_WARN_EMPTY_BODY YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_CLANG_WARN_INT_CONVERSION YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_CLANG_WARN_IMPLICIT_SIGN_CONVERSION YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_CLANG_WARN_ENUM_CONVERSION YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_CLANG_WARN_ASSIGN_ENUM YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_CLANG_WARN_SUSPICIOUS_IMPLICIT_CONVERSION YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_CLANG_WARN_UNREACHABLE_CODE YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_CLANG_WARN_CXX0X_EXTENSIONS YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_CLANG_WARN_DIRECT_OBJC_ISA_USAGE YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_CLANG_WARN_OBJC_IMPLICIT_ATOMIC_PROPERTIES YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_CLANG_WARN_SUSPICIOUS_MOVE YES)

    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_ONLY_ACTIVE_ARCH[variant=Debug] YES)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_ONLY_ACTIVE_ARCH[variant=Release] NO)
    SET_TARGET_PROPERTIES(${TARGET} PROPERTIES XCODE_ATTRIBUTE_ONLY_ACTIVE_ARCH[variant=RelWithDebInfo] NO)
ENDMACRO(SET_XCODE_ATTRIBUTES)

MACRO(FIX_WIN32_PATH VARNAME)
    IF (WIN32)
        STRING(REPLACE "/" "\\" ${VARNAME} "${${VARNAME}}")
    ENDIF()
ENDMACRO(FIX_WIN32_PATH)

MACRO(ADD_TARGET_PROPERTY TARGET PROPERTY VALUE)
    GET_TARGET_PROPERTY(CURRENT_VALUE ${TARGET} ${PROPERTY})
    IF(NOT CURRENT_VALUE)
        SET_PROPERTY(TARGET ${TARGET} PROPERTY ${PROPERTY} ${VALUE})
    ELSE()
        LIST(APPEND CURRENT_VALUE ${VALUE})
        SET_PROPERTY(TARGET ${TARGET} PROPERTY ${PROPERTY} ${CURRENT_VALUE})
    ENDIF()
ENDMACRO(ADD_TARGET_PROPERTY)

MACRO(GET_APP_VERSION GIT_DESCRIBE VERSION_YEAR VERSION_NUMBER)
    IF(NOT ${GIT_DESCRIBE})
        SET(${GIT_DESCRIBE} "v0.0")
    ENDIF()
    STRING(REGEX MATCH "v([0-9][0-9][0-9][0-9])[.]([0-9]+)" GIT_DESCRIBE_MATCH "${${GIT_DESCRIBE}}")

    IF(GIT_DESCRIBE_MATCH)
        SET(${VERSION_YEAR} ${CMAKE_MATCH_1})
        SET(${VERSION_NUMBER} ${CMAKE_MATCH_2})
    ELSE()
        MESSAGE(FATAL_ERROR "Couldn't parse version from git describe output '${${GIT_DESCRIBE}}'")
    ENDIF()
ENDMACRO(GET_APP_VERSION)

MACRO(GET_GIT_DESCRIBE GIT SOURCE_DIR GIT_DESCRIBE)
    EXECUTE_PROCESS(COMMAND ${GIT} describe --dirty WORKING_DIRECTORY ${SOURCE_DIR} OUTPUT_VARIABLE ${GIT_DESCRIBE} OUTPUT_STRIP_TRAILING_WHITESPACE)
ENDMACRO(GET_GIT_DESCRIBE)

MACRO(GET_BUILD_PLATFORM PLATFORM_NAME)
    IF(WIN32)
        SET(${PLATFORM_NAME} "Win32")
    ELSEIF(APPLE)
        SET(${PLATFORM_NAME} "MacOSX")
    ELSEIF(UNIX)
        SET(${PLATFORM_NAME} "Linux")
    ELSE()
        SET(${PLATFORM_NAME} "Unknown")
    ENDIF()
ENDMACRO(GET_BUILD_PLATFORM)

MACRO(LIB_TO_DLL LIB_PATH LIB_POSTFIX DLL_PATH)
    GET_FILENAME_COMPONENT(__LIB_DIR  "${LIB_PATH}" DIRECTORY)
    GET_FILENAME_COMPONENT(__LIB_NAME "${LIB_PATH}" NAME_WE)
    SET(${DLL_PATH} "${__LIB_DIR}/${__LIB_NAME}${LIB_POSTFIX}.dll")
ENDMACRO(LIB_TO_DLL)

MACRO(WX_LIB_TO_DLL LIB_PATH LIB_POSTFIX DLL_PATH)
    GET_FILENAME_COMPONENT(__LIB_DIR  "${LIB_PATH}" DIRECTORY)
    GET_FILENAME_COMPONENT(__LIB_NAME "${LIB_PATH}" NAME_WE)
	SET(___DLL_PATH "${__LIB_DIR}/${__LIB_NAME}${LIB_POSTFIX}.dll")
	IF (NOT EXISTS "${___DLL_PATH}")
		STRING(REGEX MATCH "([^0-9]+)([0-9]+)(.*)" __MATCH_RESULT "${__LIB_NAME}")
			SET(___PREFIX "${CMAKE_MATCH_1}")
			SET(___VERSION "${CMAKE_MATCH_2}")
			SET(___POSTFIX "${CMAKE_MATCH_3}")
			SET(___MINOR 0)
			WHILE (${___MINOR} LESS 10 AND NOT EXISTS "${___DLL_PATH}")
				SET(___DLL_PATH "${__LIB_DIR}/${___PREFIX}${___VERSION}${___MINOR}${___POSTFIX}${LIB_POSTFIX}.dll")
				MATH(EXPR ___MINOR "${___MINOR}+1")
			ENDWHILE()
		ENDIF()
    SET(${DLL_PATH} "${___DLL_PATH}")
ENDMACRO(WX_LIB_TO_DLL)
