
#include "bsp5.h"

int		outleafs;

/*
===========
PointInLeaf
===========
*/
node_t	*PointInLeaf (node_t *node, vec3_t point)
{
	double	d;
	
	if (node->contents)
		return node;
		
	d = DotProduct (planes[node->planenum].normal, point) - planes[node->planenum]. dist;
	
	if (d > 0)
		return PointInLeaf (node->children[0], point);
	
	return PointInLeaf (node->children[1], point);
}

/*
===========
PlaceOccupant
===========
*/
qboolean PlaceOccupant (int num, vec3_t point, node_t *headnode)
{
	node_t	*n;

	if (IsPathCorner(num)) return true;
        
	n = PointInLeaf (headnode, point);
	if (n->contents == CONTENTS_SOLID)
		return false;
	n->occupied = num;
	return true;
}


/*
==============
MarkLeakTrail
==============
*/
portal_t	*prevleaknode;
FILE	*leakfile;
void MarkLeakTrail (portal_t *n2)
{
	int		i, j;
	vec3_t	p1, p2, dir;
	float	len;
	portal_t *n1;

	if (hullnum)
		return;

	n1 = prevleaknode;
	prevleaknode = n2;
	
	if (!n1)
		return;
		
	VectorCopy (n2->winding->points[0], p1);
	for (i=1 ; i< n2->winding->numpoints ; i++)
	{
		for (j=0 ; j<3 ; j++)
			p1[j] = (p1[j] + n2->winding->points[i][j]) / 2;
	}
	
	VectorCopy (n1->winding->points[0], p2);
	for (i=1 ; i< n1->winding->numpoints ; i++)
	{
		for (j=0 ; j<3 ; j++)
			p2[j] = (p2[j] + n1->winding->points[i][j]) / 2;
	}
		
	VectorSubtract (p2, p1, dir);
	len = VectorLength (dir);
	VectorNormalize (dir);
	
	while (len > 2)
	{
		fprintf (leakfile,"%f %f %f\n", p1[0], p1[1], p1[2]);
		for (i=0 ; i<3 ; i++)
			p1[i] += dir[i]*2;
		len -= 2;
	}
}

void EntityHitError(int hit)
{
	entity_t	*ent = entities + hit;
	char		classname[MAX_VALUE];
	char		targetname[MAX_VALUE];
	epair_t 	*temp;
	double		*v;

	classname[0] = targetname[0] = '\0';

	for (temp = ent->epairs; temp != NULL; temp = temp->next) {
		if (strcmp(temp->key, "classname") == 0)
			strcpy(classname, temp->value);
		else if (strcmp(temp->key, "targetname") == 0)
			strcpy(targetname, temp->value);
	}

	v = ent->origin;

	ShowWarningEntry("Outside fill reached entity.");
	if (targetname[0] != '\0')
		ShowWarningEntry("%s:%s", classname, targetname);
	else
		ShowWarningEntry("%s", classname);

	ShowWarningEntry("at (%.0f,%.0f,%.0f)", v[0], v[1], v[2]);
	sleep(1);
}

int IsPathCorner(int hit)
{
	if (strcmp(ValueForKey(entities+hit, "classname"), "path_corner") == 0)
		return 1;
	else
		return 0;
}

/*
==================
RecursiveFillOutside

If fill is false, just check, don't fill
Returns true if an occupied leaf is reached
==================
*/
int		hit_occupied;
int		backdraw;
qboolean RecursiveFillOutside (node_t *l, qboolean fill)
{
	portal_t	*p;
	int			s;
	int			original_contents;

	if (l->contents == CONTENTS_SOLID)
		return false;
		
	if (l->valid == valid)
		return false;
	
	l->valid = valid;

/* Some people have been intentionaly putting lights inside sky volumes, */
/* so I have to fail the check now that I am testing */
	if (l->occupied && l->contents != CONTENTS_SKY && !IsPathCorner(l->occupied))
	{
		hit_occupied = l->occupied;

		EntityHitError(hit_occupied);

                /*drawflag = true; */
		backdraw = 4000;
		Draw_ClearWindow ();
		DrawLeaf (l, 2);

                return true;
        }

/* fill it and it's neighbors */
	original_contents = l->contents;
	if (fill)
		l->contents = CONTENTS_SOLID;
	outleafs++;

	for (p=l->portals ; p ; )
	{
		s = (p->nodes[0] == l);

	/* flood fill into skys, but not back out */
		if (original_contents != CONTENTS_SKY ||
		p->nodes[s]->contents == CONTENTS_SKY )
		{
			if (RecursiveFillOutside (p->nodes[s], fill) )
			{	/* leaked, so stop filling */
				if (backdraw-- > 0)
				{				
					MarkLeakTrail (p);
					DrawLeaf (l, 2);
				}
				return true;
			}
		}
		p = p->next[!s];
	}
	
	return false;
}

/*
==================
ClearOutFaces

==================
*/
void ClearOutFaces (node_t *node)
{
	face_t	**fp;
	
	if (node->planenum != -1)
	{
		ClearOutFaces (node->children[0]);
		ClearOutFaces (node->children[1]);
		return;
	}
	if (node->contents != CONTENTS_SOLID)
		return;

	for (fp=node->markfaces ; *fp ; fp++)
	{
	/* mark all the original faces that are removed */
		(*fp)->numpoints = 0;
	}
	node->faces = NULL;
}


/*============================================================================= */

/*
===========
FillOutside

===========
*/
qboolean FillOutside (node_t *node)
{
	int			s;
	int			i;
	qboolean	inside;
	
	ShowStatusEntry("Filling in outside space.");
	if (nofill)
	{
		ShowTempEntry("Skipped.");
		return false;
	}
		
	inside = false;
	for (i=1 ; i<num_entities ; i++)
	{
		if (!VectorCompare(entities[i].origin, vec3_origin))
		{
			if (PlaceOccupant (i, entities[i].origin, node))
				inside = true;
		}
        }

	if (!inside)
	{
		ShowWarningEntry("Hullnum %i:  Entity in empty space.", hullnum);
		ShowWarningEntry("No filling performed.");
		sleep(1);
                return false;
	}

	s = !(outside_node.portals->nodes[1] == &outside_node);

/* first check to see if an occupied leaf is hit */
	outleafs = 0;
	valid++;

	prevleaknode = NULL;
	
	if (!hullnum)
	{
		leakfile = fopen (pointfilename, "w");
		if (!leakfile)
			Error ("Couldn't open %s\n", pointfilename);
	}

        if (RecursiveFillOutside (outside_node.portals->nodes[s], false))
	{
                if (!hullnum)
			fclose (leakfile);
		return false;
	}
	if (!hullnum)
		fclose (leakfile);

/* now go back and fill things in */
	valid++;
	RecursiveFillOutside (outside_node.portals->nodes[s], true);

/* remove faces from filled in leafs	 */
	ClearOutFaces (node);
	
	ShowTempEntry("%5i outside leafs filled.", outleafs);
	return true;
}


