#include <windows.h>
#include <io.h>
#include <stdio.h>
#include <string.h>
#include "file_list.h"

void copy_path(char *src, char *dst)
{
  strcpy(dst,src);

  char *last_path_char=0;
  char *d = dst;

  while (*d)
  {
    if ((*d=='/') || (*d=='\\'))
      last_path_char = d;
    
    d++;
  }
  
  if (last_path_char)
    *(last_path_char+1) = 0;
  else
    *dst = 0;
}

file_name_class *FileList(char *mask)
{
	struct _finddata_t f;
	
  long rc;		
	
	file_name_class *file_names=0;
	
  char path[256];

  copy_path(mask,path);

  rc = _findfirst(mask,&f);	
	
  if (rc != -1)
  {
    do
    {
      if (!(f.attrib & _A_SUBDIR))
      {
        char full_fname[256];
        sprintf(full_fname,"%s%s",path,f.name);

        file_name_class *fn = new file_name_class(full_fname);
    
        fn->next = file_names;
        file_names = fn;
      }    
  	} while (_findnext(rc,&f) != -1);
  }
  
	return file_names;
}
