/*
Copyright (C) 1996-1997 GX Media, Inc.
Copyright (C) 2010 Ronie Salgado

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"
#include "QPropObject.h"
#include "QooleDoc.h"
#include "QMainFrame.h"

BEGIN_EVENT_TABLE(QPropObject, QPropSheetPage)
END_EVENT_TABLE()

QPropObject::QPropObject(wxWindow *parent)
	: QPropSheetPage(parent)
{
	wxSizer *topSizer = new wxBoxSizer(wxHORIZONTAL);
	wxSizer *headers = new wxBoxSizer(wxVERTICAL);
	wxSizer *values = new wxBoxSizer(wxVERTICAL);
	topSizer->Add(headers, 0, wxEXPAND|wxALL, 5);
	topSizer->Add(values, 0, wxEXPAND|wxALL, 5);

	// Number of objects
	wxStaticText *label = new wxStaticText(this, wxID_ANY, _("Number of objects:"));
	headers->Add(label, 0, wxALIGN_LEFT);
	objectCount = new wxStaticText(this, wxID_ANY, wxT("0"));
	values->Add(objectCount);

	headers->AddSpacer(5);
	values->AddSpacer(5);

	// Position
	label = new wxStaticText(this, wxID_ANY, _("Position:"));
	headers->Add(label, 0, wxALIGN_LEFT);
	objectPosition = new wxStaticText(this, wxID_ANY, wxT("(0,0,0)"));
	values->Add(objectPosition);

	// Dimensions
	label = new wxStaticText(this, wxID_ANY, _("Dimensions:"));
	headers->Add(label, 0, wxALIGN_LEFT);
	objectDimension = new wxStaticText(this, wxID_ANY, wxT("(0,0,0)"));
	values->Add(objectDimension);

	headers->AddSpacer(5);
	values->AddSpacer(5);

	// Brush count
	label = new wxStaticText(this, wxID_ANY, _("Brush Count:"));
	headers->Add(label, 0, wxALIGN_LEFT);
	brushCount = new wxStaticText(this, wxID_ANY, wxT("0"));
	values->Add(brushCount);

	// Entity count.
	label = new wxStaticText(this, wxID_ANY, _("Entity Count:"));
	headers->Add(label, 0, wxALIGN_LEFT);
	entityCount = new wxStaticText(this, wxID_ANY, wxT("0"));
	values->Add(entityCount);

	SetSizer(topSizer);
	SetAutoLayout(true);
}

QPropObject::~QPropObject()
{
}

void QPropObject::OnUpdate(wxView* sender, wxObject* hint)
{
	int flags = 0;
	Object *scope = NULL;

	if(hint && hint->IsKindOf(CLASSINFO(QDocHint)))
	{
		QDocHint *qhint = static_cast<QDocHint*> (hint);
		flags = qhint->flags;
		scope = qhint->scope;
	}

	if (flags & DUAV_NOQPROPPAGES /*|| !active*/)
		return;

	Selector *selector = &GetMainFrame()->GetSelector();
	Object *editScope = selector->GetScopePtr();
	if(scope != NULL && editScope != scope &&
		!scope->IsMyAncestor(*editScope))
		return;

	if(scope == NULL || flags & (DUAV_OBJSSEL | DUAV_SCOPECHANGED))
	{
		int count = selector->GetNumMSelectedObjects();
		objectCount->SetLabel(wxString::Format(wxT("%d"), count));
	}

	if(scope == NULL || flags & (DUAV_OBJSSEL | DUAV_OBJSMODSTRUCT | DUAV_SCOPECHANGED))
	{
		IterLinkList<ObjectPtr> it(selector->GetMSelectedObjects());
		it.Reset();
		int brushCount, entCount;
		brushCount = entCount = 0;

		while(!it.IsDone())
		{
			Object *obj = it.GetNext()->GetPtr();
			if(obj->HasBrush())
				brushCount++;
			if(obj->HasEntity())
				entCount++;
		}

		this->brushCount->SetLabel(wxString::Format(wxT("%d"), brushCount));
		this->entityCount->SetLabel(wxString::Format(wxT("%d"), entCount));
	}

	if(scope ==NULL ||
		flags & (DUAV_OBJSMODATTRIB | DUAV_SCOPECHANGED | DUAV_OBJSSEL))
	{
		Vector3d center;
		selector->GetMSelectedObjectsCenter(center);
		objectPosition->SetLabel(wxString::Format(wxT("(%.0f, %.0f, %.0f)"),
				center.GetX(), center.GetY(), center.GetZ()));

		Vector3d position;
		Vector3d minVec, maxVec, tMinVec, tMaxVec;
		IterLinkList<ObjectPtr> it(selector->GetMSelectedObjects());
		it.Reset();

		if(!it.IsDone())
		{
			Object *obj = it.GetNext()->GetPtr();
			position = obj->GetPosition();
			obj->GetBoundingVectors(tMinVec, tMaxVec);
			tMinVec.AddVector(position);
			tMaxVec.AddVector(position);
		}

		while(!it.IsDone())
		{
			Object *obj = it.GetNext()->GetPtr();
			position = obj->GetPosition();
			obj->GetBoundingVectors(minVec, maxVec);
			minVec.AddVector(position);
			maxVec.AddVector(position);
			tMinVec.NewVector(Min(tMinVec.GetX(), minVec.GetX()),
							  Min(tMinVec.GetY(), minVec.GetY()),
							  Min(tMinVec.GetZ(), minVec.GetZ()));
			tMaxVec.NewVector(Min(tMaxVec.GetX(), maxVec.GetX()),
							  Min(tMaxVec.GetY(), maxVec.GetY()),
							  Min(tMaxVec.GetZ(), maxVec.GetZ()));
		}
		tMaxVec.SubVector(tMinVec);
		objectDimension->SetLabel(wxString::Format(wxT("(%.0f, %.0f, %.0f)"),
				tMaxVec.GetX(), tMaxVec.GetY(), tMaxVec.GetZ()));
	}
}
