/*
Copyright (C) 1996-1997 GX Media, Inc.
Copyright (C) 2010 Ronie Salgado

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef QTEXTURE_MANAGER_H
#define QTEXTURE_MANAGER_H

#include "Texture.h"
#include "QTexturePanel.h"

class QTextureManager: public wxDialog
{
public:
	QTextureManager(wxWindow *parent);
	~QTextureManager();

	DECLARE_EVENT_TABLE();
private:
	void OnClose(wxCloseEvent &ev);
	void OnOk(wxCommandEvent &ev);

	void OnGameChoice(wxCommandEvent &ev);
	void OnArchiveSelection(wxCommandEvent &ev);
	void OnArchiveTextureSelection(wxCommandEvent &ev);
	void OnListSelection(wxCommandEvent &ev);
	void OnListTextureSelection(wxCommandEvent &ev);

	void OnAddArchive(wxCommandEvent &ev);
	void OnRemoveArchive(wxCommandEvent &ev);
	void OnNewList(wxCommandEvent &ev);
	void OnRemoveList(wxCommandEvent &ev);
	void OnAdd(wxCommandEvent &ev);
	void OnRemove(wxCommandEvent &ev);
	void BuildArchiveList();
	void SetTexInfo(const wxString &name, int offset);

	// Widgets.
	wxChoice *gameChoice;
	wxListBox *textureArchiveSelection;
	wxListBox *textureArchive;
	wxListBox *textureListSelection;
	wxListBox *textureList;
	QTexturePanel *texturePanel;
	wxButton *addArchive;
	wxButton *removeArchive;
	wxButton *newList;
	wxButton *removeList;
	wxButton *add;
	wxButton *remove;

	// Data.
	Game *game;
	wxString texDirName;
	TexList *texList;
	TexEntry texEntry;
	int startGameIndex;

};

#endif //QTEXTURE_MANAGER_H
