/*
Copyright (C) 2010 Ronie Salgado

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef QCHILDFRAME_H
#define QCHILDFRAME_H

class QView;
class QMainFrame;
class QViewPanel: public wxPanel
{
public:
	QViewPanel(QView *view, wxWindow *parent,
			wxWindowID id, const wxString &title);
	~QViewPanel();

	bool Create(QView *view, wxWindow *parent, wxWindowID id, const wxString &title);

	virtual bool ProcessEvent(wxEvent& event);

	QView *GetView() {return childView;}
	void SetView(QView *view) {childView = view;}

	// Event handlers.
    void OnActivate(wxActivateEvent& event);
    void OnCloseWindow(wxCloseEvent& event);
	void OnPaint(wxPaintEvent &event);
	void OnSize(wxSizeEvent &event);
	void OnMouseEnter(wxMouseEvent &event);
    bool Destroy() { childView = NULL; return wxPanel::Destroy(); }
	DECLARE_EVENT_TABLE();

private:
	QView *childView;
	wxString childTitle;
};

#endif //QCHILDFRAME_H
