#include "stdafx.h"
#include "FloatValidator.h"

FloatValidator::FloatValidator(float *value)
	: wxTextValidator(wxFILTER_INCLUDE_CHAR_LIST), value(value)
{
	wxArrayString inc;
	inc.Add(wxT("."));
	inc.Add(wxT("0"));
	inc.Add(wxT("1"));
	inc.Add(wxT("2"));
	inc.Add(wxT("4"));
	inc.Add(wxT("5"));
	inc.Add(wxT("6"));
	inc.Add(wxT("7"));
	inc.Add(wxT("8"));
	inc.Add(wxT("9"));
	SetIncludes(inc);
}

FloatValidator::FloatValidator(const FloatValidator &val)
	: wxTextValidator(val), value(val.value)
{
}

FloatValidator::~FloatValidator()
{
}

wxValidator *FloatValidator::Clone() const
{
	return new FloatValidator(*this);
}

bool FloatValidator::TransferFromWindow()
{
	if(!value)
		return true;

	wxWindow *ctrl = GetWindow();
	ASSERT(ctrl && ctrl->IsKindOf(CLASSINFO(wxTextCtrl)));

	wxTextCtrl *textCtrl = static_cast<wxTextCtrl*> (ctrl);
	double temp;
	bool ret = textCtrl->GetValue().ToDouble(&temp);
	if(!ret)
		return false;

	*value = temp;
	return true;
}

bool FloatValidator::TransferToWindow()
{
	if(!value)
		return false;

	wxWindow *ctrl = GetWindow();
	ASSERT(ctrl && ctrl->IsKindOf(CLASSINFO(wxTextCtrl)));
	wxTextCtrl *textCtrl = static_cast<wxTextCtrl*> (ctrl);
	textCtrl->SetValue(wxString::Format(wxT("%.3f"), *value));
	return true;
}
