/*
Copyright (C) 1996-1997 GX Media, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef __ENTLIST_H
#define __ENTLIST_H

#include "List.h"
#include "Geometry.h"

//==================== EntList ====================

#ifndef LINE_MAX
#define LINE_MAX	160
#endif

#define VAR_UNDEF	0
#define VAR_VEC		1
#define VAR_INT		2
#define VAR_STR		3
#define VAR_NOTUSER	4
#define	VAR_FLOAT	5
#define VAR_TYPEDEF	6
#define VAR_FLAGDEF	7
#define VAR_USER	8
#define VAR_COLOR	9
#define VAR_STRDEF	10
#define VAR_COLORF  11

class EntList;

class EntClass : public ElmNode {
public:
	EntClass(const wxString &name);
	~EntClass(void);

	int count;
	wxString name;
	int nonmodels;
	int models;
};

struct QDefEntry {
	int val;
	wxString str;
	wxString name;
	wxString desc;
};

class EntDef : public ElmNode {
public:
	EntDef(char hbuf[LINE_MAX], char lbuf[][LINE_MAX], int lnum, EntList *entList);
	~EntDef(void);

	const wxString &GetName(void) { return name; }
	int GetDefType(void) { return deftype; }
	int GetNumEntries(void) { return entries; }
	QDefEntry *GetEntryNum(int i) { ASSERT(i >= 0 && i < entries); return &qdefentry[i]; }

private:
	wxString name;
	int deftype;
	int entries;
	QDefEntry *qdefentry;
};

struct QEntEntry {
	wxString name;
	int vartype;
	wxString desc;
	wxString def;
	EntDef *entDef;
};

#define ENTFILE_GEM 1
#define ENTFILE_MDL 2
#define ENTFILE_MD2 3

class EntInfo : public ElmNode {
public:
	EntInfo(char hbuf[LINE_MAX], char lbuf[][LINE_MAX], int lnum, EntList *entList);
	~EntInfo(void);

	const wxString &GetClassname(void) { return classname; }
	const wxString &GetClassdesc(void) { return classdesc; }
	const wxString &GetFilename(void) { return filename; }
	bool IsModel(void) { return isModel; }
	EntClass *GetEntClass(void) { return entClass; }
	WireFrameGeom *Use(bool &isModel, bool &isAdjust);
	void DoneUse(void);

	size_t GetNumEntries(void) { return entries.size(); }
	QEntEntry *GetEntryNum(size_t i) { ASSERT(i < entries.size()); return &entries[i]; }

	bool AddUserEntry(const wxString &name);

private:
	wxString classname;
	wxString classdesc;
	EntClass *entClass;
	wxString desc;

	int filetype;
	wxString filename;

	std::vector<QEntEntry> entries;

	bool isModel;
	bool isAdjust;
	WireFrameGeom *wfGeomPtr;
};

class EntList : public ElmNode {
public:
	EntList(const wxString &filename);
	~EntList(void);

	LinkList<EntInfo> &GetInfoList(void) { return infoList; }
	LinkList<EntDef> &GetDefList(void) { return defList; }
	LinkList<EntClass> &GetClassList(void) { return classList; }

	EntClass *FindClass(const wxString &name);
	EntDef *FindDef(const wxString &name);
	EntInfo *FindEnt(const wxString &name);

	const wxString &GetName(void) const { return name; }
	const wxString &GetGameName(void) { return gameName; }

	static void Set(EntList *_entList) { entList = _entList; }
	static EntList *Get(void) { return entList; }
	static EntList *Find(const wxString &name);
	static void Exit(void);

	static LinkList<EntList> &GetEntLists(void) { return entLists; }

	static WireFrameGeom *cross1Ptr;
	static WireFrameGeom *cross2Ptr;
	static WireFrameGeom *undefPtr;

private:
	void ReadEntFile(const wxString &filename);

	wxString name;
	wxString gameName;

	LinkList<EntClass> classList;
	LinkList<EntDef> defList;
	LinkList<EntInfo> infoList;

	static EntList *entList;
	static LinkList<EntList> entLists;
};


#endif
