/*
Copyright (C) 2011 Ronie Salgado

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"
#include "QMainFrame.h"
#include "QChildFrame.h"

IMPLEMENT_DYNAMIC_CLASS(QChildFrame, wxPanel);

BEGIN_EVENT_TABLE(QChildFrame, wxPanel)
	EVT_SIZE(QChildFrame::OnSize)
END_EVENT_TABLE()

QChildFrame::QChildFrame()
{
	notebook = NULL;
}

QChildFrame::QChildFrame(wxAuiNotebook *parent, wxWindowID id, const wxString &title)
{
	Create(parent, id, title);
}

QChildFrame::~QChildFrame()
{
	QMainFrame *mainFrame = GetMainFrame();
	if(mainFrame)
		mainFrame->OnDestroyChild(this);
}

void QChildFrame::Create(wxAuiNotebook *parent, wxWindowID id, const wxString &title)
{
	wxPanel::Create(parent->GetParent(), id, wxDefaultPosition, wxDefaultSize);
	parent->AddPage(this, title);
	notebook = parent;
	SetTitle(title);
	
	// Update the layout.
	wxSizeEvent size;
	wxPostEvent(this, size);
}
	
void QChildFrame::SetTitle(const wxString &title)
{
	this->title = title;
	
	ASSERT(notebook);
	int index = notebook->GetPageIndex(this);
	ASSERT(index >= 0 && index < notebook->GetPageCount());
	notebook->SetPageText(index, title);
}

const wxString &QChildFrame::GetTitle() const
{
	return title;
}

void QChildFrame::OnSize(wxSizeEvent &event)
{
	if(GetAutoLayout())
		Layout();
}
