#include "stdafx.h"
#include "QConf2DView.h"

BEGIN_EVENT_TABLE(QConf2DView, wxPanel)
END_EVENT_TABLE()

QConf2DView::QConf2DView(wxWindow *parent)
	: wxPanel(parent)
{
	// Create the panel layout.
	wxBoxSizer *panelSizer = new wxBoxSizer(wxVERTICAL);

	// Grids
	wxStaticBoxSizer *gridsBox = new wxStaticBoxSizer(wxHORIZONTAL, this, _("Grids"));
	panelSizer->Add(gridsBox, 0, wxEXPAND|wxALL, 5);

	wxFlexGridSizer *gridsSizer = new wxFlexGridSizer(4, 2);
	gridsBox->Add(gridsSizer, 0, wxEXPAND);

	wxCheckBox *gridLines = new wxCheckBox(this, wxID_ANY, _("Grid Lines"));
	wxStaticText *label = new wxStaticText(this, wxID_ANY, _("Size:"));
	wxComboBox *gridSize = new wxComboBox(this, wxID_ANY);
	gridsSizer->Add(gridLines, 0, wxALIGN_CENTER_VERTICAL);
	gridsSizer->AddSpacer(10);
	gridsSizer->Add(label, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL);
	gridsSizer->Add(gridSize, 0, wxEXPAND);

	wxCheckBox *thickGrid = new wxCheckBox(this, wxID_ANY, _("Thick Grid Lines"));
	label = new wxStaticText(this, wxID_ANY, _("For each grids:"));
	wxTextCtrl *thickGridAmount = new wxTextCtrl(this, wxID_ANY);
	gridsSizer->Add(thickGrid, 0, wxALIGN_CENTER_VERTICAL);
	gridsSizer->AddSpacer(10);
	gridsSizer->Add(label, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL);
	gridsSizer->Add(thickGridAmount, 0, wxEXPAND);

	// Snapping.
	wxStaticBoxSizer *snapBox = new wxStaticBoxSizer(wxHORIZONTAL, this, _("Snapping"));
	panelSizer->AddSpacer(5);
	panelSizer->Add(snapBox, 0, wxEXPAND|wxALL, 5);

	wxFlexGridSizer *snapSizer = new wxFlexGridSizer(4, 2);
	snapBox->Add(snapSizer, 0, wxEXPAND);

	wxCheckBox *snap = new wxCheckBox(this, wxID_ANY, _("Snap"));
	label = new wxStaticText(this, wxID_ANY, _("Size:"));
	wxComboBox *snapSize = new wxComboBox(this, wxID_ANY);
	snapSizer->Add(snap, 0, wxALIGN_CENTER_VERTICAL);
	snapSizer->AddSpacer(10);
	snapSizer->Add(label, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL);
	snapSizer->Add(snapSize, 0, wxEXPAND);

	wxCheckBox *rotationalSnap = new wxCheckBox(this, wxID_ANY, _("Rotational Snap"));
	label = new wxStaticText(this, wxID_ANY, _("For each degrees:"));
	wxComboBox *rotSnapAmount = new wxComboBox(this, wxID_ANY);
	snapSizer->Add(rotationalSnap, 0, wxALIGN_CENTER_VERTICAL);
	snapSizer->AddSpacer(10);
	snapSizer->Add(label, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL);
	snapSizer->Add(rotSnapAmount, 0, wxEXPAND);

	SetSizer(panelSizer);
	panelSizer->Fit(this);
}

QConf2DView::~QConf2DView()
{
}
