#include "stdafx.h"
#include "QConf3DView.h"

BEGIN_EVENT_TABLE(QConf3DView, wxPanel)
END_EVENT_TABLE()

inline void AddPair(wxWindow *parent, wxSizer *sizer, const wxString &caption)
{
	wxStaticText *label = new wxStaticText(parent, wxID_ANY, caption);
	wxTextCtrl *text = new wxTextCtrl(parent, wxID_ANY);
	sizer->Add(label, 0, wxALIGN_CENTER_VERTICAL);
	sizer->Add(text);
}

QConf3DView::QConf3DView(wxWindow *parent)
	: wxPanel(parent)
{
	// Create the panel layout.
	wxBoxSizer *panelSizer = new wxBoxSizer(wxVERTICAL);

	// Top layout.
	wxBoxSizer *topSizer = new wxBoxSizer(wxHORIZONTAL);
	panelSizer->Add(topSizer, 0, wxEXPAND|wxALL, 5);

	// Eye Rotate left.
	wxStaticBoxSizer *eyeLeftSizer = new wxStaticBoxSizer(wxVERTICAL, this,
			_("Eye Rotate: Left Button"));
	topSizer->Add(eyeLeftSizer, 1, wxEXPAND);
	topSizer->AddSpacer(20);

	wxCheckBox *inverseMouse = new wxCheckBox(this, wxID_ANY, _("InverseMouse"));
	eyeLeftSizer->Add(inverseMouse);

	// Eye Rotate right.
	wxStaticBoxSizer *eyeRightSizer = new wxStaticBoxSizer(wxVERTICAL, this,
			_("Eye Rotate: Right Button"));
	topSizer->Add(eyeRightSizer, 1, wxEXPAND);

	wxRadioButton *crystalBall = new wxRadioButton(this, wxID_ANY, _("Spin Crystal Ball"));
	wxRadioButton *orbitEdit = new wxRadioButton(this, wxID_ANY, _("Orbit Edit Focus"));
	eyeRightSizer->Add(crystalBall);
	eyeRightSizer->Add(orbitEdit);

	// Bottom layout.
	wxStaticBoxSizer *flyBox = new wxStaticBoxSizer(wxVERTICAL, this, _("Fly Through"));
	panelSizer->AddSpacer(5);
	panelSizer->Add(flyBox, 0, wxEXPAND|wxALL, 5);

	wxFlexGridSizer *flySizer = new wxFlexGridSizer(5, 4);
	flyBox->Add(flySizer, 0, wxEXPAND);

	AddPair(this, flySizer, _("Walk Speed"));
	flySizer->AddSpacer(10);
	AddPair(this, flySizer, _("Sensitivity"));
	AddPair(this, flySizer, _("Forward"));
	flySizer->AddSpacer(10);
	AddPair(this, flySizer, _("Fly Up"));
	AddPair(this, flySizer, _("Step Left"));
	flySizer->AddSpacer(10);
	AddPair(this, flySizer, _("Step Right"));
	AddPair(this, flySizer, _("Backward"));
	flySizer->AddSpacer(10);
	AddPair(this, flySizer, _("Fly Down"));

	SetSizer(panelSizer);
	panelSizer->Fit(this);
}

QConf3DView::~QConf3DView()
{
}
