/*
Copyright (C) 2010 Ronie Salgado

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef QPROPSHEET_H
#define QPROPSHEET_H

#include "QPropFile.h"
#include "QPropObject.h"
#include "QPropEntity.h"
#include "QPropTexture.h"

class QPropSheet: public wxFrame
{
public:
	QPropSheet(wxWindow *parent, wxRect *position);
	~QPropSheet();

	enum SheetID
	{
		SID_FILE = 0,
		SID_OBJECT,
		SID_ENTITY,
		SID_TEXTURE,
		SID_SURFACE,
		SID_CONTENT,
	};

	QPropFile *GetFileSheet()
	{ return propFile; }

	QPropObject *GetObjectSheet()
	{ return propObject; }

	QPropEntity *GetEntitySheet()
	{ return propEntity; }

	QPropTexture *GetTextureSheet()
	{ return propTexture; }

	void SetPage(SheetID id);

	void RegisterDocument(QooleDoc *doc);
	void OnCloseWindow(wxCloseEvent &event);
	void OnNotebookChanged(wxAuiNotebookEvent &event);
	void OnNotebookChanging(wxAuiNotebookEvent &event);
	DECLARE_EVENT_TABLE();

private:
	wxAuiNotebook *notebook;
	QPropFile *propFile;
	QPropObject *propObject;
	QPropEntity *propEntity;
	QPropTexture *propTexture;

};

#endif //QPROPSHEET_H
