/*
Copyright (C) 1996-1997 GX Media, Inc.
Copyright (C) 2010 Ronie Salgado

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef QOOLE_H
#define QOOLE_H

#include "QooleDocManager.h"

class QMainFrame;
class QooleApp: public wxApp
{
public:
	QooleApp();
	~QooleApp();

	bool OnInit();
	int OnExit();

	QooleDocManager *GetDocManager();
	int GetProfileInt(const wxString &section, const wxString &name, int def=0);
	void WriteProfileInt(const wxString &section, const wxString &name, int value);
	wxString GetProfileString(const wxString &section, const wxString &name);
	void WriteProfileString(const wxString &section, const wxString &name, const wxString &value);

private:
	typedef std::map<wxString, wxString> ProfileSection;
	typedef std::map<wxString, ProfileSection*> Profile;

	ProfileSection *GetProfileSection(const wxString &section, bool create);
	void ReadProfile();
	void WriteProfile();

	Profile profile;


	QooleDocManager docManager;
	wxString configDir;
};

DECLARE_APP(QooleApp);

#endif //QOOLE_H
