#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>


static unsigned char pal[768]=
{
   0x00,0x00,0x00,0x0F,0x0F,0x0F,0x1F,0x1F,0x1F,0x2F,0x2F,0x2F,0x3F,0x3F,0x3F,0x4B,
   0x4B,0x4B,0x5B,0x5B,0x5B,0x6B,0x6B,0x6B,0x7B,0x7B,0x7B,0x8B,0x8B,0x8B,0x9B,0x9B,
   0x9B,0xAB,0xAB,0xAB,0xBB,0xBB,0xBB,0xCB,0xCB,0xCB,0xDB,0xDB,0xDB,0xEB,0xEB,0xEB,
   0x0F,0x0B,0x07,0x17,0x0F,0x0B,0x1F,0x17,0x0B,0x27,0x1B,0x0F,0x2F,0x23,0x13,0x37,
   0x2B,0x17,0x3F,0x2F,0x17,0x4B,0x37,0x1B,0x53,0x3B,0x1B,0x5B,0x43,0x1F,0x63,0x4B,
   0x1F,0x6B,0x53,0x1F,0x73,0x57,0x1F,0x7B,0x5F,0x23,0x83,0x67,0x23,0x8F,0x6F,0x23,
   0x0B,0x0B,0x0F,0x13,0x13,0x1B,0x1B,0x1B,0x27,0x27,0x27,0x33,0x2F,0x2F,0x3F,0x37,
   0x37,0x4B,0x3F,0x3F,0x57,0x47,0x47,0x67,0x4F,0x4F,0x73,0x5B,0x5B,0x7F,0x63,0x63,
   0x8B,0x6B,0x6B,0x97,0x73,0x73,0xA3,0x7B,0x7B,0xAF,0x83,0x83,0xBB,0x8B,0x8B,0xCB,
   0x00,0x00,0x00,0x07,0x07,0x00,0x0B,0x0B,0x00,0x13,0x13,0x00,0x1B,0x1B,0x00,0x23,
   0x23,0x00,0x2B,0x2B,0x07,0x2F,0x2F,0x07,0x37,0x37,0x07,0x3F,0x3F,0x07,0x47,0x47,
   0x07,0x4B,0x4B,0x0B,0x53,0x53,0x0B,0x5B,0x5B,0x0B,0x63,0x63,0x0B,0x6B,0x6B,0x0F,
   0x07,0x00,0x00,0x0F,0x00,0x00,0x17,0x00,0x00,0x1F,0x00,0x00,0x27,0x00,0x00,0x2F,
   0x00,0x00,0x37,0x00,0x00,0x3F,0x00,0x00,0x47,0x00,0x00,0x4F,0x00,0x00,0x57,0x00,
   0x00,0x5F,0x00,0x00,0x67,0x00,0x00,0x6F,0x00,0x00,0x77,0x00,0x00,0x7F,0x00,0x00,
   0x13,0x13,0x00,0x1B,0x1B,0x00,0x23,0x23,0x00,0x2F,0x2B,0x00,0x37,0x2F,0x00,0x43,
   0x37,0x00,0x4B,0x3B,0x07,0x57,0x43,0x07,0x5F,0x47,0x07,0x6B,0x4B,0x0B,0x77,0x53,
   0x0F,0x83,0x57,0x13,0x8B,0x5B,0x13,0x97,0x5F,0x1B,0xA3,0x63,0x1F,0xAF,0x67,0x23,
   0x23,0x13,0x07,0x2F,0x17,0x0B,0x3B,0x1F,0x0F,0x4B,0x23,0x13,0x57,0x2B,0x17,0x63,
   0x2F,0x1F,0x73,0x37,0x23,0x7F,0x3B,0x2B,0x8F,0x43,0x33,0x9F,0x4F,0x33,0xAF,0x63,
   0x2F,0xBF,0x77,0x2F,0xCF,0x8F,0x2B,0xDF,0xAB,0x27,0xEF,0xCB,0x1F,0xFF,0xF3,0x1B,
   0x0B,0x07,0x00,0x1B,0x13,0x00,0x2B,0x23,0x0F,0x37,0x2B,0x13,0x47,0x33,0x1B,0x53,
   0x37,0x23,0x63,0x3F,0x2B,0x6F,0x47,0x33,0x7F,0x53,0x3F,0x8B,0x5F,0x47,0x9B,0x6B,
   0x53,0xA7,0x7B,0x5F,0xB7,0x87,0x6B,0xC3,0x93,0x7B,0xD3,0xA3,0x8B,0xE3,0xB3,0x97,
   0xAB,0x8B,0xA3,0x9F,0x7F,0x97,0x93,0x73,0x87,0x8B,0x67,0x7B,0x7F,0x5B,0x6F,0x77,
   0x53,0x63,0x6B,0x4B,0x57,0x5F,0x3F,0x4B,0x57,0x37,0x43,0x4B,0x2F,0x37,0x43,0x27,
   0x2F,0x37,0x1F,0x23,0x2B,0x17,0x1B,0x23,0x13,0x13,0x17,0x0B,0x0B,0x0F,0x07,0x07,
   0xBB,0x73,0x9F,0xAF,0x6B,0x8F,0xA3,0x5F,0x83,0x97,0x57,0x77,0x8B,0x4F,0x6B,0x7F,
   0x4B,0x5F,0x73,0x43,0x53,0x6B,0x3B,0x4B,0x5F,0x33,0x3F,0x53,0x2B,0x37,0x47,0x23,
   0x2B,0x3B,0x1F,0x23,0x2F,0x17,0x1B,0x23,0x13,0x13,0x17,0x0B,0x0B,0x0F,0x07,0x07,
   0xDB,0xC3,0xBB,0xCB,0xB3,0xA7,0xBF,0xA3,0x9B,0xAF,0x97,0x8B,0xA3,0x87,0x7B,0x97,
   0x7B,0x6F,0x87,0x6F,0x5F,0x7B,0x63,0x53,0x6B,0x57,0x47,0x5F,0x4B,0x3B,0x53,0x3F,
   0x33,0x43,0x33,0x27,0x37,0x2B,0x1F,0x27,0x1F,0x17,0x1B,0x13,0x0F,0x0F,0x0B,0x07,
   0x6F,0x83,0x7B,0x67,0x7B,0x6F,0x5F,0x73,0x67,0x57,0x6B,0x5F,0x4F,0x63,0x57,0x47,
   0x5B,0x4F,0x3F,0x53,0x47,0x37,0x4B,0x3F,0x2F,0x43,0x37,0x2B,0x3B,0x2F,0x23,0x33,
   0x27,0x1F,0x2B,0x1F,0x17,0x23,0x17,0x0F,0x1B,0x13,0x0B,0x13,0x0B,0x07,0x0B,0x07,
   0xFF,0xF3,0x1B,0xEF,0xDF,0x17,0xDB,0xCB,0x13,0xCB,0xB7,0x0F,0xBB,0xA7,0x0F,0xAB,
   0x97,0x0B,0x9B,0x83,0x07,0x8B,0x73,0x07,0x7B,0x63,0x07,0x6B,0x53,0x00,0x5B,0x47,
   0x00,0x4B,0x37,0x00,0x3B,0x2B,0x00,0x2B,0x1F,0x00,0x1B,0x0F,0x00,0x0B,0x07,0x00,
   0x00,0x00,0xFF,0x0B,0x0B,0xEF,0x13,0x13,0xDF,0x1B,0x1B,0xCF,0x23,0x23,0xBF,0x2B,
   0x2B,0xAF,0x2F,0x2F,0x9F,0x2F,0x2F,0x8F,0x2F,0x2F,0x7F,0x2F,0x2F,0x6F,0x2F,0x2F,
   0x5F,0x2B,0x2B,0x4F,0x23,0x23,0x3F,0x1B,0x1B,0x2F,0x13,0x13,0x1F,0x0B,0x0B,0x0F,
   0x2B,0x00,0x00,0x3B,0x00,0x00,0x4B,0x07,0x00,0x5F,0x07,0x00,0x6F,0x0F,0x00,0x7F,
   0x17,0x07,0x93,0x1F,0x07,0xA3,0x27,0x0B,0xB7,0x33,0x0F,0xC3,0x4B,0x1B,0xCF,0x63,
   0x2B,0xDB,0x7F,0x3B,0xE3,0x97,0x4F,0xE7,0xAB,0x5F,0xEF,0xBF,0x77,0xF7,0xD3,0x8B,
   0xA7,0x7B,0x3B,0xB7,0x9B,0x37,0xC7,0xC3,0x37,0xE7,0xE3,0x57,0x7F,0xBF,0xFF,0xAB,
   0xE7,0xFF,0xD7,0xFF,0xFF,0x67,0x00,0x00,0x8B,0x00,0x00,0xB3,0x00,0x00,0xD7,0x00,
   0x00,0xFF,0x00,0x00,0xFF,0xF3,0x93,0xFF,0xF7,0xC7,0xFF,0xFF,0xFF,0x9F,0x5B,0x53,
};

typedef struct
{
   int ofs;
   int wsize;
   int msize;
   unsigned char type;
   unsigned char cmpr;
   unsigned short dummy;
   char name[16];
} wad_entry_t;

typedef struct
{
   char magic[4];
   int num_entries;
   int dir_ofs;
} wad_header_t;


FILE *p;

char *ow;

#define BUF_SIZE 16384
unsigned char buf[BUF_SIZE];


void CopyChunk(FILE *to,FILE *from,int size)
{
   while (size>BUF_SIZE)
   {
      fread(buf,1,BUF_SIZE,from);
      fwrite(buf,1,BUF_SIZE,to);
      size-=BUF_SIZE;
   }
   fread(buf,1,size,from);
   fwrite(buf,1,size,to);
}


static char lastwname[256];

static FILE *f;
static wad_entry_t *dir;
static wad_header_t h;

void close_wad(void)
{
   if (!lastwname[0]) return;

   fseek(f,0,SEEK_SET);
   fwrite(&h,1,sizeof(wad_header_t),f);
   fseek(f,h.dir_ofs,SEEK_SET);
   fwrite(dir,1,sizeof(wad_entry_t)*h.num_entries,f);
   fclose(f);
}

void open_wad(const char *name)
{
   if (!strcmp(name,lastwname)) return;
   close_wad();
   strcpy(lastwname,name);
   
   f=fopen(name,"r+b");
   if (!f)
   {
      f=fopen(name,"w+b");
      strncpy(h.magic,"WAD2",4);
      h.num_entries=1;
      h.dir_ofs=sizeof(wad_header_t)+768;
      fwrite(&h,1,sizeof(wad_header_t),f);
      fwrite(pal,1,768,f);
      dir=malloc(sizeof(wad_entry_t));
      memset(dir,0,sizeof(wad_entry_t));
      strcpy(dir[0].name,"pal");
      dir[0].ofs=sizeof(wad_header_t);
      dir[0].wsize=dir[0].msize=768;
      dir[0].type=0x40;
   }
   else
   {
      fread(&h,1,sizeof(wad_header_t),f);
      dir=malloc(sizeof(wad_entry_t)*h.num_entries);
      fseek(f,h.dir_ofs,SEEK_SET);
      fread(dir,1,sizeof(wad_entry_t)*h.num_entries,f);
   }
}


void AddFile(int size,char *name,char *wname)
{
   wad_entry_t *e;
   int i;

   if (!name[0]) return;

   open_wad(wname);

   for (i=0;i<h.num_entries;i++)
      if (!strcasecmp(dir[i].name,name))
         return;
   printf("adding '%s' to '%s'\n",name,wname);

   fseek(f,h.dir_ofs,SEEK_SET);
   CopyChunk(f,p,size);

   dir=realloc(dir,sizeof(wad_entry_t)*(h.num_entries+1));
   e=&dir[h.num_entries++];
   memset(e,0,sizeof(wad_entry_t));
   strcpy(e->name,name);
   e->ofs=h.dir_ofs;
   e->msize=e->wsize=size;
   e->type=0x44;
   h.dir_ofs+=size;
}


typedef struct
{
   char name[16];
   int width;
   int height;
   int ofs[4];
} miphead_t;

void addbsp(void)
{
   int baseofs;
   struct
   {
      int ofs,size;
   } entry;

   char wadname[256];
   int numtex;
   int ofs;
   
   int i;

   miphead_t mh;

   baseofs=ftell(p);

   fread(&i,1,4,p);
   if (i!=0x1d)
   {
      printf("\n");
      fprintf(stderr,"BSP version %i should be 29, skipping\n",i);
      return;
   }

   if (!ow)
   {
      char *c;
      
      fread(&entry,1,sizeof(entry),p);
      fseek(p,entry.ofs+baseofs,SEEK_SET);
      fread(buf,1,BUF_SIZE,p);
      buf[BUF_SIZE-1]=0;

      c=strstr(buf,"\"wad\"");
      if (!c)
      {
         fprintf(stderr,"Can't find 'wad' key, skipping\n");
         return;
      }

      c+=7;
      if (!strchr(c,'"'))
      {
         fprintf(stderr,"Can't parse 'wad' key, skipping\n");
         return;
      }
      *strchr(c,'"')=0;
      c=strrchr(c,'/');
      if (!c)
      {
         fprintf(stderr,"Can't parse 'wad' key, skipping\n");
         return;
      }
      c++;
      strcpy(wadname,c);
   }
   else
      strcpy(wadname,ow);

   printf(" %s\n",wadname);

   fseek(p,baseofs+4+8+8,SEEK_SET);
   fread(&entry,1,sizeof(entry),p);
   fseek(p,baseofs+entry.ofs,SEEK_SET);

   fread(&numtex,1,4,p);

   for (i=0;i<numtex;i++)
   {
      fseek(p,baseofs+entry.ofs+(i+1)*4,SEEK_SET);
      fread(&ofs,1,4,p);
      fseek(p,baseofs+entry.ofs+ofs,SEEK_SET);
      fread(&mh,1,sizeof(miphead_t),p);

      fseek(p,baseofs+entry.ofs+ofs,SEEK_SET);
      AddFile(sizeof(miphead_t)+mh.width*mh.height*85/64,
         mh.name,wadname);
   }
}


typedef struct
{
   char magic[4];
   int ofs;
   int size;
} pak_header_t;

typedef struct
{
   char name[56];
   int ofs;
   int size;
} pak_entry_t;

void addpak(const char *name)
{
   pak_header_t h;
   pak_entry_t e;
   int i;

   p=fopen(name,"rb");
   if (!p)
   {
      fprintf(stderr,"Can't open %s, skipping\n",name);
      return;
   }
   fread(&h,1,sizeof(pak_header_t),p);
   if (strncmp(h.magic,"PACK",4))
   {
      fclose(p);
      fprintf(stderr,"Invalid header %c%c%c%c in %s, skipping\n",
         h.magic[0],h.magic[1],h.magic[2],h.magic[3],name);
      return;
   }
   h.size/=64;
   for (i=0;i<h.size;i++)
   {
      fseek(p,h.ofs+sizeof(pak_entry_t)*i,SEEK_SET);
      fread(&e,1,sizeof(pak_entry_t),p);

      if (strlen(e.name)<4) continue;
      if (strncasecmp(&e.name[strlen(e.name)-4],".bsp",4)) continue;

      printf("Extracting textures from %s to",e.name);
      fseek(p,e.ofs,SEEK_SET);
      addbsp();
   }
   fclose(p);
}

int main(int argc, char **argv)
{
   int i;
   
   printf("cwad2 v1.1  (c) 1996, 2000 Alexander Malmberg\n");
   if (argc<3)
   {
      printf(
"Syntax:\n"
"   cwad2 tex.wad pak0.pak pak1.pak ...\n"
"\n"
"   Extracts all textures from all .bsp files in the .pak files to the .wad\n"
"   file. If the .wad file name is '-', the textures will be extracted to the\n"
"   .wad files the .bsp files say they should be in (might not work with all\n"
"   .bsp files, but works with Quake I's normal pak0.pak and pak1.pak).\n"
"\n"
"   To quickly get all Quake I textures into a .wad file, go to the directory\n"
"   with the .pak files (.../quake/id1) and run:\n"
"\n"
"     cwad2 tex.wad pak0.pak pak1.pak\n"
"\n"
"   tex.wad will then contain all textures from Quake I. If you want the\n"
"   textures in different categories, run:\n"
"\n"
"     cwad2 - pak0.pak pak1.pak\n"
"\n"
"   See cwad2.txt for more information.\n"
"\n"
      );
      return 0;
   }

   ow=argv[1];
   if (!strcmp(ow,"-")) ow=NULL;

   for (i=2;i<argc;i++)
      addpak(argv[i]);

   close_wad();

   return 0;
}

