/*
entity.c file of the MergeT3D Source Code

Copyright 1997, 1998 Alexander Malmberg
Copyright Gyro Gearloose
Copyright 1996, Trey Harrison and Chris Carollo

This program is distributed under the GNU General Public License.
See legal.txt for more information.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "types.h"

#include "entity.h"

#include "memory.h"


void InitEntity(entity_t *ent)
{
	ent->key = NULL;
	ent->value = NULL;

	ent->numkeys = 0;

	ent->Next = NULL;
	ent->Last = NULL;
}


char *GetKeyValue(entity_t *ent, char *key)
{
	int i;
	int found;

	/* Find key/value */
	found=0;
	for (i=0; i<ent->numkeys; i++)
	{
		if (strcmp(ent->key[i], key) == 0)
		{
			found=1;
			break;
		}
	}

	if (!found)
	{
		return NULL;
	}

	/* Return pointer to value */
	return ent->value[i];
}

void CreateKeyValue(entity_t *ent, char *key, char *value)
{

	/* Allocate new key/value pair */
	ent->key = (char **)Q_realloc(ent->key, sizeof(char *) * (ent->numkeys + 1));
	ent->value = (char **)Q_realloc(ent->value, sizeof(char *) * (ent->numkeys + 1));

	/* Allocate new key and value strings */
	ent->key[ent->numkeys] = (char *)Q_malloc(sizeof(char) * (strlen(key) + 1));
	ent->value[ent->numkeys] = (char *)Q_malloc(sizeof(char) * (strlen(value) + 1));

	/* Copy key/value into new structure */
	strcpy(ent->key[ent->numkeys], key);
	strcpy(ent->value[ent->numkeys], value);

	/* And increment the counter */
	ent->numkeys++;
}

void SetKeyValue(entity_t *ent, char *key, char *value)
{
	int i;
	int found;

	/* If setting to null, remove key */
	if (value[0] == '\0')
		return;

	/* Find key/value */
	found = 0;
	for (i=0; i<ent->numkeys; i++)
	{
		if (strcmp(ent->key[i], key) == 0)
		{
			found = 1;
			break;
		}
	}

	/* Create a new entry if it wasn't found */
	if (!found)
	{
		CreateKeyValue(ent, key, value);
		return;
	}

	/* Otherwise, resize and copy the new value in */
	ent->value[i] = Q_realloc(ent->value[i], sizeof(char) * (strlen(value) + 1));

	strcpy(ent->value[i], value);
}

