//TYPES.H header file of Quest v1.1 Source Code
//Info on the Quest source code can be found in qsrcinfo.txt

//Copyright 1996, Trey Harrison and Chris Carollo
//For non-commercial use only. More rules apply, read legal.txt
//for a full description of usage restrictions.

#ifndef TYPES_H
#define TYPES_H

typedef struct
{
	float x;
	float y;
	float z;
} vec3_t;

/* Map */

typedef struct texdef_s
{
	char    name[32];  /* Name of texture for plane */
		                /* needs to be 32 chars for Quake2 */
	float   shift[2];
	float   rotate;
	float   scale[2];

/* Quake2 only fields */
   int     contents;  /* Contents of this plane */
   int     flags;     /* Flags */
   int     value;     /* Strength of light */
} texdef_t;

typedef struct
{
	int startvertex;            // ID of the start vertex
	int endvertex;              // ID of the end vertex
} edge_t;

typedef struct
{
	float   dist;                   // distance to the plane
	vec3_t  normal;                 // Normal to plane
	vec3_t  center;
	int    *verts;                  // indices in the brush->verts array
	int     num_verts;

   texdef_t tex;
} plane_t;


typedef struct brush_s
{
	plane_t  *plane;
	int       num_planes;
	vec3_t   *verts;                 // Array of vertices
	vec3_t   *tverts;
	int       num_verts;
	edge_t   *edges;                 // Array of edges
	int       num_edges;             // (in the local verts array)
	vec3_t    center;
	struct entity_s *EntityRef;
	struct brush_s  *Next;
	struct brush_s  *Last;
} brush_t;


/* My data structures */

typedef struct entity_s
{
	char   **key;
	char   **value;
	int      numkeys;
	struct entity_s *Last;
	struct entity_s *Next;
} entity_t;

#define MAX_FACE_POINTS 64

typedef struct
{
	char    misc;
	int     numpts;
	vec3_t  planepts[3];
	vec3_t  pts[MAX_FACE_POINTS];  // points on face / plane (the polygon pts)
	vec3_t  normal;                // Normal to plane
	float   dist;

   texdef_t tex;
} face_my_t;

typedef face_my_t plane_my_t;

typedef struct
{
	int numfaces;
	face_my_t *faces;
} brush_my_t;

typedef struct t3d_texture_s
{
	struct t3d_texture_s *next;

	// Here're the paramters we'll use to find a match in the MAP file with
	vec3_t location;	// Narrows it down to only a few brushes
	vec3_t normal;		// Polygon's normal
	vec3_t identify;	// x,y,z of 1st, 2nd, and 3rd vertices of poly

	// Here're the parameters that we'll replace our texture info with
	char texname[16];
	vec3_t origin;		// Polygon's origin
	int panu;
	int panv;
	vec3_t textureu;
	vec3_t texturev;
} t3d_texture_t;

#endif

