/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse.vdf;

import com.technofovea.hl2parse.JxPathUtil;
import com.technofovea.hl2parse.vdf.VdfAttribute;
import com.technofovea.hl2parse.vdf.VdfRoot;
import com.technofovea.hl2parse.xml.MaterialRefList;
import com.technofovea.hl2parse.xml.MaterialReference;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.jxpath.JXPathContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaterialReader {
    private static final Logger logger = LoggerFactory.getLogger(MaterialReader.class);
    static final String PATCH_INCLUDE = "include";
    VdfRoot root;
    JXPathContext context;
    MaterialRefList props;
    Set<String> textures = new HashSet<String>();
    Set<String> materials = new HashSet<String>();

    public static final MaterialRefList getDefaultMaterialSettings() throws JAXBException {
        InputStream is = MaterialReader.class.getResourceAsStream("DefaultMaterials.xml");
        return MaterialReader.loadFromXml(is);
    }

    public static final MaterialRefList loadFromXml(InputStream stream) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{MaterialReference.class, MaterialRefList.class});
        Unmarshaller um = jc.createUnmarshaller();
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        Object o = um.unmarshal(stream);
        return (MaterialRefList)o;
    }

    public MaterialReader(VdfRoot rootNode, MaterialRefList props) {
        this.root = rootNode;
        this.context = JXPathContext.newContext((Object)this.root);
        JxPathUtil.addFunctions(this.context);
        Iterator allAttribs = this.context.iterate("//attributes");
        block4: while (allAttribs.hasNext()) {
            VdfAttribute attrPair = (VdfAttribute)allAttribs.next();
            String key = attrPair.getName();
            if (key.endsWith("2")) {
                logger.trace("Found 2-suffixed attribute variation: {}", (Object)key);
                key = key.substring(0, key.length() - 1);
            }
            if (key.equalsIgnoreCase(PATCH_INCLUDE)) {
                logger.trace("Found possible patch-include shader material: {}", (Object)key);
                this.materials.add(attrPair.getValue());
            }
            for (MaterialReference ref : props) {
                String val;
                if (!ref.hasName(key) || ref.hasIgnoreValue(val = attrPair.getValue())) continue;
                switch (ref.getType()) {
                    case MATERIAL: {
                        logger.trace("Found material: {}", (Object)val);
                        if (!val.toLowerCase().endsWith(".vmt")) {
                            val = val + ".vmt";
                        }
                        this.materials.add("materials/" + val);
                        break;
                    }
                    case TEXTURE: {
                        logger.trace("Found texture: {}", (Object)val);
                        if (!val.toLowerCase().endsWith(".vtf")) {
                            val = val + ".vtf";
                        }
                        this.textures.add("materials/" + val);
                    }
                }
                continue block4;
            }
        }
    }

    public Set<String> getMaterials() {
        return new HashSet<String>(this.materials);
    }

    public Set<String> getTextures() {
        return new HashSet<String>(this.textures);
    }
}

