/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.BitSet;

public class ParseUtil {
    public static final int NULL_TERMINATOR = 0;
    static final char[] HEX_CHARS = "0123456789ABCDEF".toCharArray();

    public static String toAscii(int i, boolean reversed) {
        byte[] bytes = new byte[4];
        if (!reversed) {
            bytes[0] = (byte)(i >> 24);
            bytes[1] = (byte)(i << 8 >> 24);
            bytes[2] = (byte)(i << 16 >> 24);
            bytes[3] = (byte)(i << 24 >> 24);
        } else {
            bytes[3] = (byte)(i >> 24);
            bytes[2] = (byte)(i << 8 >> 24);
            bytes[1] = (byte)(i << 16 >> 24);
            bytes[0] = (byte)(i << 24 >> 24);
        }
        return new String(bytes);
    }

    public static String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(HEX_CHARS[(b & 0xF0) >>> 4]);
            sb.append(HEX_CHARS[b & 0xF]);
        }
        return sb.toString();
    }

    public static String toHex(byte b) {
        return ParseUtil.toHex(new byte[]{b});
    }

    public static String toHex(ByteBuffer buf) {
        int orig = buf.position();
        StringBuilder sb = new StringBuilder();
        while (buf.remaining() > 0) {
            byte b = buf.get();
            sb.append(HEX_CHARS[(b & 0xF0) >>> 4]);
            sb.append(HEX_CHARS[b & 0xF]);
        }
        buf.position(orig);
        return sb.toString();
    }

    public static String readString(ByteBuffer bb, int limit) {
        int max = Math.min(limit, bb.remaining());
        byte[] name = new byte[max];
        bb.get(name);
        return ParseUtil.readString(name, max);
    }

    public static String readString(byte[] buf, int limit) {
        int max;
        int firstnull = max = Math.min(limit, buf.length);
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] != 0) continue;
            firstnull = i;
            break;
        }
        return new String(Arrays.copyOf(buf, firstnull));
    }

    public static MappedByteBuffer mapFile(File target) throws IOException {
        FileInputStream fos = new FileInputStream(target);
        FileChannel fc = fos.getChannel();
        MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, target.length());
        mbb.order(ByteOrder.LITTLE_ENDIAN);
        return mbb;
    }

    public static BitSet readBitset(ByteBuffer bb, int numbytes) {
        byte[] barr = new byte[numbytes];
        bb.get(barr);
        BitSet ret = new BitSet(numbytes * 8);
        for (int i_byte = 0; i_byte < barr.length; ++i_byte) {
            for (int i = 0; i < 8; ++i) {
                int idx = i_byte * 8 + i;
                boolean isSet = (barr[i_byte] & 1 << i) > 0;
                ret.set(idx, isSet);
            }
        }
        return ret;
    }
}

