/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse.registry;

import com.technofovea.hl2parse.JxPathUtil;
import com.technofovea.hl2parse.registry.BlobFolder;
import com.technofovea.hl2parse.registry.BlobParseFailure;
import com.technofovea.hl2parse.registry.BlobRaw;
import com.technofovea.hl2parse.registry.CdrParser;
import com.technofovea.hl2parse.registry.RegParser;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ClientRegistry.class);
    protected static final String CDR_SECTION_NAME = "ContentDescriptionRecord";
    BlobFolder root;
    CdrParser cdr = null;
    JXPathContext ctx;

    public ClientRegistry(BlobFolder root) throws BlobParseFailure {
        this.root = root;
        this.ctx = JXPathContext.newContext((Object)root);
        JxPathUtil.addFunctions((JXPathContext)this.ctx);
        this.cdr = this.createCdr();
    }

    CdrParser createCdr() throws BlobParseFailure {
        logger.debug("Finding compressed ContentDescriptionRecord section");
        BlobRaw br = (BlobRaw)this.ctx.getValue("/values[@name='ContentDescriptionRecord']");
        if (br == null) {
            throw new BlobParseFailure("Could not find ContentDescriptionRecord segment. Check that Steam is up-to-date.");
        }
        logger.debug("Extracting compressed CDR section");
        ByteBuffer expandedBuf = RegParser.decompress(br.asBuffer());
        logger.debug("Creating reader for decompressed CDR data");
        CdrParser cp = new CdrParser(expandedBuf);
        return cp;
    }

    public CdrParser getContentDescriptionRecord() {
        return this.cdr;
    }

    public JXPathContext getRootContext() {
        return this.ctx;
    }

    public List<String> getUsernames() {
        logger.debug("Retrieving known Steam username(s)");
        Iterator users = this.ctx.iterate("/folders[@name='_Users']/folders/*/name");
        ArrayList<String> ret = new ArrayList<String>();
        while (users.hasNext()) {
            ret.add((String)users.next());
        }
        logger.debug("Usernames found: {}", ret);
        return ret;
    }
}

