/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse.fgd;

import com.technofovea.hl2parse.fgd.FgdEntClass;
import com.technofovea.hl2parse.fgd.VisGroup;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FgdSpec {
    Map<String, FgdEntClass> definedClasses = new HashMap<String, FgdEntClass>();
    Map<String, VisGroup> visGroups = new HashMap<String, VisGroup>();
    boolean boundsSet = false;
    int mapMin = Short.MIN_VALUE;
    int mapMax = 32768;
    Set<String> excludedMaterials = new HashSet<String>();

    static String cleanQuotes(String input) {
        return input.replace("\"", " ");
    }

    static String quoteVal(String value) {
        try {
            int i = Integer.parseInt(value);
            return value;
        }
        catch (NumberFormatException nfe) {
            return "\"" + value + "\"";
        }
    }

    public int getMapMax() {
        return this.mapMax;
    }

    public void setMapBounds(int mapMin, int mapMax) throws IllegalArgumentException {
        if (mapMax < mapMin) {
            throw new IllegalArgumentException("Maximum value is less than minimum value");
        }
        this.mapMin = mapMin;
        this.mapMax = mapMax;
        this.boundsSet = true;
    }

    public void setMapBounds(String mapMin, String mapMax) throws IllegalArgumentException {
        int low = Integer.parseInt(mapMin);
        int high = Integer.parseInt(mapMax);
        this.setMapBounds(low, high);
    }

    public int getMapMin() {
        return this.mapMin;
    }

    public void addEntClass(String name, FgdEntClass item) {
        this.definedClasses.put(name, item);
    }

    public FgdEntClass getEntClass(String name) {
        return this.definedClasses.get(name);
    }

    public Set<String> getEntClassNames() {
        return new HashSet<String>(this.definedClasses.keySet());
    }

    public void clearEntClases() {
        this.definedClasses.clear();
    }

    public VisGroup getVisGroup(String name) {
        return this.visGroups.get(name);
    }

    public Set<String> getVisGroupNames() {
        return new HashSet<String>(this.visGroups.keySet());
    }

    public void addVisGroup(String name, VisGroup grp) {
        this.visGroups.put(name, grp);
    }

    public Set<String> getExcludedMaterials() {
        return this.excludedMaterials;
    }

    public void setExcludedMaterials(Set<String> excludedMaterials) {
        this.excludedMaterials = excludedMaterials;
    }

    public String toText() {
        StringBuilder sb = new StringBuilder();
        if (this.boundsSet) {
            sb.append("@mapsize(" + this.mapMin + "," + this.mapMax + ")\n");
        }
        if (this.excludedMaterials.size() > 0) {
            sb.append("@MaterialExclusion\n[");
            for (String item : this.excludedMaterials) {
                sb.append(FgdSpec.quoteVal(item));
                sb.append("\n");
            }
            sb.append("]\n");
        }
        for (String groupName : this.visGroups.keySet()) {
            VisGroup vg = this.visGroups.get(groupName);
            sb.append("@AutoVisGroup = ");
            sb.append(groupName);
            sb.append("\n[\n");
            for (String subName : vg.getSectionNames()) {
                sb.append(FgdSpec.quoteVal(subName));
                sb.append("\n[\n");
                for (String item : vg.getSectionItems(subName)) {
                    sb.append(FgdSpec.quoteVal(item));
                    sb.append("\n");
                }
                sb.append("]\n");
            }
            sb.append("]\n");
        }
        for (String clazzName : this.definedClasses.keySet()) {
            FgdEntClass entClass = this.definedClasses.get(clazzName);
            sb.append(entClass.toText(clazzName));
        }
        return sb.toString();
    }
}

