/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse.bsp;

import com.technofovea.hl2parse.OffsetBuffer;
import com.technofovea.hl2parse.ParseUtil;
import com.technofovea.hl2parse.bsp.BspLumpHeader;
import com.technofovea.hl2parse.bsp.BspParseException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BinaryBspAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(BinaryBspAnalyzer.class);
    protected ByteBuffer coreBuffer;
    protected int version;
    protected BspLumpHeader[] lumps;

    public BinaryBspAnalyzer(ByteBuffer bb) throws BspParseException {
        logger.debug("Processing map data ({} bytes)", (Object)bb.remaining());
        this.coreBuffer = bb.asReadOnlyBuffer();
        this.coreBuffer.order(ByteOrder.LITTLE_ENDIAN);
        try {
            this.loadBasic();
        }
        catch (BufferUnderflowException bue) {
            throw new BspParseException(bue);
        }
    }

    private void loadBasic() throws BspParseException {
        int num_lumps = this.getNumLumps();
        byte[] expected_hdr = this.getInitialHeader();
        this.lumps = new BspLumpHeader[num_lumps];
        byte[] hdr = new byte[expected_hdr.length];
        this.coreBuffer.get(hdr);
        if (!Arrays.equals(hdr, expected_hdr)) {
            String hexHdr = ParseUtil.toHex(hdr);
            String hexExpected = ParseUtil.toHex(expected_hdr);
            throw new BspParseException("File does not begin with expected header. Expected " + hexExpected + " but got " + hexHdr);
        }
        int versionNumber = this.coreBuffer.getInt();
        logger.debug("Map version is {}", (Object)versionNumber);
        if (!this.handlesVersion(versionNumber)) {
            throw new BspParseException("Cannot handle file format version " + versionNumber);
        }
        this.version = versionNumber;
        for (int i = 0; i < this.getNumLumps(); ++i) {
            logger.trace("Loading lump header #{}", (Object)i);
            this.lumps[i] = new BspLumpHeader(this.coreBuffer);
        }
    }

    protected OffsetBuffer getLumpData(int lumpNum) {
        if (lumpNum < 0 || lumpNum >= this.lumps.length) {
            logger.error("BSP lump {} was out-of-range and could not be found", (Object)lumpNum);
            return null;
        }
        BspLumpHeader l = this.lumps[lumpNum];
        return new OffsetBuffer(this.coreBuffer, l.getOffset(), l.getLength());
    }

    protected abstract boolean handlesVersion(int var1);

    protected abstract int getNumLumps();

    protected abstract byte[] getInitialHeader();
}

