/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse.vdf;

import com.technofovea.hl2parse.vdf.VdfAttribute;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VdfNode {
    private String name = "";
    private List<VdfNode> children = new ArrayList<VdfNode>();
    private List<VdfAttribute> attributes = new ArrayList<VdfAttribute>();

    public String toString() {
        return this.toString(0, false);
    }

    public String toPrettyString() {
        return this.toString(0, true);
    }

    protected String toString(int indentLevel, boolean pretty) {
        StringBuilder sb = new StringBuilder();
        StringBuilder tabs = new StringBuilder();
        for (int i = 0; i < indentLevel; ++i) {
            tabs.append("\t");
        }
        if (this.hasName()) {
            sb.append((CharSequence)tabs);
            sb.append("\"");
            sb.append(this.getName());
            sb.append("\"");
            sb.append("\n");
        }
        sb.append((CharSequence)tabs);
        sb.append("{\n");
        int maxKeyLen = 0;
        if (pretty) {
            for (VdfAttribute att : this.attributes) {
                if (att.getName().length() <= maxKeyLen) continue;
                maxKeyLen = att.getName().length();
            }
        }
        for (VdfAttribute att : this.attributes) {
            sb.append((CharSequence)tabs);
            sb.append("\t");
            sb.append("\"");
            sb.append(att.getName());
            sb.append("\"");
            if (pretty) {
                sb.append("    ");
                for (int i = 0; i < maxKeyLen - att.getName().length(); ++i) {
                    sb.append(" ");
                }
            } else {
                sb.append("    ");
            }
            sb.append("\"");
            sb.append(att.getValue());
            sb.append("\"");
            sb.append("\n");
        }
        for (VdfNode vn : this.children) {
            String childString = vn.toString(indentLevel + 1, pretty);
            sb.append(childString);
        }
        sb.append((CharSequence)tabs);
        sb.append("}\n");
        return sb.toString();
    }

    public boolean addChild(VdfNode n) {
        if (n == this) {
            return false;
        }
        return this.children.add(n);
    }

    public void addAttribute(String key, String value) {
        VdfAttribute va = new VdfAttribute(key, value);
        this.attributes.add(va);
    }

    public void setName(String s) {
        this.name = s;
    }

    public List<VdfNode> getChildren() {
        return this.children;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public List<VdfAttribute> getAttributes() {
        return this.attributes;
    }
}

