/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class OffsetBuffer {
    protected ByteBuffer parent;
    protected int parentOffset;
    protected ByteBuffer buf;

    public OffsetBuffer(ByteBuffer parent, int parentOffset, int len) {
        this.parent = parent;
        this.parentOffset = parentOffset;
        int pos = parent.position();
        int lim = parent.limit();
        parent.position(parentOffset);
        parent.limit(parentOffset + len);
        this.buf = parent.slice();
        parent.position(pos);
        parent.limit(lim);
        this.buf.order(ByteOrder.LITTLE_ENDIAN);
    }

    public ByteBuffer getBuf() {
        return this.buf;
    }

    public ByteBuffer getParent() {
        return this.parent;
    }

    public int getParentOffset() {
        return this.parentOffset;
    }

    public int getAbsolutePosition() {
        return this.parentOffset + this.buf.position();
    }
}

