/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse.registry;

import com.technofovea.hl2parse.registry.BlobParseFailure;
import com.technofovea.hl2parse.registry.CellCollection;
import com.technofovea.hl2parse.registry.CellItem;
import com.technofovea.hl2parse.registry.RegParser;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CdrParser {
    private static final Logger logger = LoggerFactory.getLogger(CdrParser.class);
    public static final int Zone_Applications = 1;
    static final int BYTE_TRUE = 1;
    static final int IDX_APP = 1;
    static final int IDX_NAME = 2;
    static final int IDX_FOLDER = 3;
    static final int IDX_LAUNCH = 6;
    ByteBuffer core;

    public CdrParser(ByteBuffer data) {
        this.core = data;
    }

    static ByteBuffer getData(ByteBuffer current, Integer ... indices) throws BlobParseFailure {
        logger.trace("Retrieving nested index-based values from content data description: {}", (Object)Arrays.toString((Object[])indices));
        current = current.asReadOnlyBuffer();
        current.order(ByteOrder.LITTLE_ENDIAN);
        current.clear();
        for (int j = 0; j < indices.length; ++j) {
            int index = indices[j];
            CellCollection cd = RegParser.parseCell(current);
            boolean found = false;
            for (CellItem ci : cd) {
                int curIndex = ci.getMeta().getInt();
                if (index != curIndex) continue;
                current = ci.getPayload();
                found = true;
                break;
            }
            if (found) continue;
            throw new BlobParseFailure("Unable to find last index in sequence " + Arrays.copyOf(indices, j));
        }
        return current;
    }

    public ByteBuffer getData(Integer ... indices) throws BlobParseFailure {
        return CdrParser.getData(this.core, indices);
    }

    public List<AppDependency> getAppDependencies(int appid) throws BlobParseFailure {
        logger.debug("Getting app dependencies for app {}", (Object)appid);
        ArrayList<AppDependency> ret = new ArrayList<AppDependency>();
        ByteBuffer fsrBlob = this.getData(1, appid, 12);
        CellCollection cd = RegParser.parseCell(fsrBlob);
        for (CellItem ci : cd) {
            CellCollection cd2 = RegParser.parseCell(ci.getPayload());
            AppDependency ad = new AppDependency();
            if (cd2.items.size() < 3 || cd2.items.size() > 4) {
                throw new BlobParseFailure("App filesystem entries are expected to have 3 or 4 sections. Found " + cd2.items.size() + " instead.");
            }
            block7: for (CellItem ci2 : cd2) {
                int i = ci2.getMeta().getInt();
                switch (i) {
                    case 1: {
                        ad.appid = ci2.getPayload().getInt();
                        continue block7;
                    }
                    case 2: {
                        ad.mountName = RegParser.getText(ci2.getPayload());
                        continue block7;
                    }
                    case 3: {
                        ad.optional = ci2.getPayload().get() == 1;
                        continue block7;
                    }
                    case 4: {
                        ad.operatingSystem = RegParser.getText(ci2.getPayload());
                        continue block7;
                    }
                }
                throw new BlobParseFailure("App filesystem entry found with unexpected section number " + i);
            }
            ret.add(ad);
        }
        return ret;
    }

    public List<Integer> getAllAppIds() throws BlobParseFailure {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        ByteBuffer appBuf = this.getData(1);
        CellCollection cc = RegParser.parseCell(appBuf);
        for (CellItem ci : cc) {
            int id = ci.getMeta().getInt();
            ret.add(id);
        }
        return ret;
    }

    public String getAppName(int appid) throws BlobParseFailure {
        logger.debug("Getting app name for app {}", (Object)appid);
        ArrayList ret = new ArrayList();
        ByteBuffer nameBuf = this.getData(1, appid, 2);
        return RegParser.getText(nameBuf);
    }

    public String getAppFolderName(int appid) throws BlobParseFailure {
        logger.debug("Getting app folder name for app {}", (Object)appid);
        ByteBuffer nameBuf = this.getData(1, appid, 3);
        return RegParser.getText(nameBuf);
    }

    public Map<String, String> getLaunchCommands(int appid) throws BlobParseFailure {
        logger.debug("Getting launch commands for app {}", (Object)appid);
        HashMap<String, String> ret = new HashMap<String, String>();
        ByteBuffer launchConfigs = this.getData(1, appid, 6);
        CellCollection cd = RegParser.parseCell(launchConfigs);
        for (CellItem ci : cd) {
            int launchNum = ci.getMeta().getInt();
            String name = RegParser.getText(CdrParser.getData(ci.getPayload(), 1));
            String cmdline = RegParser.getText(CdrParser.getData(ci.getPayload(), 2));
            ret.put(name, cmdline);
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AppDependency
    implements Comparable<AppDependency> {
        public int appid = -1;
        public boolean optional = true;
        public String mountName = "";
        public String operatingSystem = null;

        @Override
        public int compareTo(AppDependency o) {
            return this.appid - o.appid;
        }
    }
}

