/*
 * Decompiled with CFR 0.152.
 */
import com.technofovea.hl2parse.ParseUtil;
import com.technofovea.hl2parse.registry.BlobFolder;
import com.technofovea.hl2parse.registry.CdrParser;
import com.technofovea.hl2parse.registry.ClientRegistry;
import com.technofovea.hl2parse.registry.RegParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;

public class ExtractBlobData {
    static final int[] GoldsourceGames = new int[]{10, 20, 30, 40, 50, 60, 70, 80, 100, 130};
    static final int[] SourceGames = new int[]{220, 240, 280, 300, 320, 340, 360, 380, 400, 420, 440, 500, 550, 570, 620, 630, 1800, 4000};
    static final int[] SdkGames = new int[]{211, 215, 218, 513, 629};
    static final String CR_BLOB = "clientregistry.blob";
    static final String STEAM_APP_DATA = "config/SteamAppData.vdf";

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: ExtractBlobData \"C:\\Path\\To\\Steam\"");
            System.exit(1);
        }
        String steamDir = args[0];
        File originalBlob = new File(steamDir, CR_BLOB);
        File blobfile = ExtractBlobData.createTempCopy(originalBlob);
        BlobFolder bf = RegParser.parseClientRegistry(ParseUtil.mapFile(blobfile));
        ClientRegistry reg = new ClientRegistry(bf);
        CdrParser cdr = reg.getContentDescriptionRecord();
        FileWriter fw = new FileWriter(new File("BlobData.cs"));
        fw.write("// This file is automatically generated by ExtractBlobData.\r\n");
        fw.write("// To regenerate it, run: ExtractBlobData \"C:\\Path\\To\\Steam\"\r\n");
        fw.write("\r\n");
        fw.write("using System.Collections.Generic;\r\n");
        fw.write("\r\n");
        fw.write("namespace Sledge.Editor.GameFiles\r\n");
        fw.write("{\r\n");
        fw.write("    public static class SteamGames\r\n");
        fw.write("    {\r\n");
        fw.write("        public static List<SteamGame> Games { get; set; }\r\n");
        fw.write("\r\n");
        fw.write("        static SteamGames()\r\n");
        fw.write("        {\r\n");
        fw.write("            Games = new List<SteamGame>\r\n");
        fw.write("                        {\r\n");
        ExtractBlobData.PrintData(cdr, GoldsourceGames, fw);
        ExtractBlobData.PrintData(cdr, SourceGames, fw);
        ExtractBlobData.PrintData(cdr, SdkGames, fw);
        fw.write("                        };\r\n");
        fw.write("        }\r\n");
        fw.write("    }\r\n");
        fw.write("}\r\n");
        fw.close();
        System.out.println("Done.");
    }

    private static void PrintData(CdrParser cdr, int[] games, FileWriter fw) throws Exception {
        for (int i : games) {
            ArrayList<String> deps = new ArrayList<String>();
            ExtractBlobData.GetDependenciesRecursive(deps, cdr, i);
            fw.write("                            new SteamGame(");
            fw.write(Integer.toString(i));
            fw.write(", \"");
            fw.write(cdr.getAppName(i));
            fw.write("\", new List<string>\r\n");
            fw.write("                                                         {\r\n");
            for (String s : deps) {
                fw.write("                                                             \"");
                fw.write(s);
                fw.write("\",\r\n");
            }
            fw.write("                                                         }),\r\n");
        }
    }

    public static void GetDependenciesRecursive(ArrayList<String> list, CdrParser cdr, int appid) throws Exception {
        String folderName = cdr.getAppFolderName(appid);
        if (list.contains(folderName)) {
            return;
        }
        list.add(folderName);
        for (CdrParser.AppDependency ad : cdr.getAppDependencies(appid)) {
            if (ad.operatingSystem == null) {
                ad.operatingSystem = "windows";
            }
            if (ad.appid == appid || ad.optional || !ad.operatingSystem.equals("windows")) continue;
            ExtractBlobData.GetDependenciesRecursive(list, cdr, ad.appid);
        }
    }

    public static File createTempCopy(File source) throws IOException {
        String ext = "blob";
        File dest = File.createTempFile("packbsp_temp_", "." + ext);
        dest.deleteOnExit();
        FileInputStream fis = new FileInputStream(source);
        FileOutputStream fos = new FileOutputStream(dest);
        IOUtils.copy((InputStream)fis, (OutputStream)fos);
        fis.close();
        fos.close();
        return dest;
    }
}

