/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse.fgd;

import com.technofovea.hl2parse.fgd.FgdSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoicesValue
implements Comparable<ChoicesValue> {
    private String value;
    private String description;

    public ChoicesValue(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getValue() {
        return this.value;
    }

    public String toText() {
        String valueOutput = FgdSpec.quoteVal(this.value);
        String ret = valueOutput + ":\"" + this.getDescription() + "\"";
        return ret;
    }

    @Override
    public int compareTo(ChoicesValue o) {
        int difference = this.getValue().compareTo(o.getValue());
        if (difference != 0) {
            return difference;
        }
        return this.getDescription().compareTo(o.getDescription());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChoicesValue other = (ChoicesValue)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.description == null ? other.description != null : !this.description.equals(other.description));
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + (this.value != null ? this.value.hashCode() : 0);
        hash = 23 * hash + (this.description != null ? this.description.hashCode() : 0);
        return hash;
    }
}

