import com.technofovea.hl2parse.ParseUtil;
import com.technofovea.hl2parse.registry.BlobFolder;
import com.technofovea.hl2parse.registry.CdrParser;
import com.technofovea.hl2parse.registry.ClientRegistry;
import com.technofovea.hl2parse.registry.RegParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;

/*
using System.Collections.Generic;

namespace Sledge.Editor.GameFiles
{
    public static class SteamGames
    {
        public static List<SteamGame> Games { get; set; }

        static SteamGames()
        {
            Games = new List<SteamGame>
                        {
                            new SteamGame(1, "Name", new List<string>
                                                         {
                                                             "Dependencies"
                                                         })
                        };
        }
    }
}
*/
public class ExtractBlobData 
{
    final static int[] GoldsourceGames = new int[] {
        10,20,30,40,50,60,70,80,100,130
    };
    final static int[] SourceGames = new int[] {
        220,240,280,300,320,340,360,380,400,420,440,500,550,570,620,630,1800,4000
    };
    
    final static int[] SdkGames = new int[] {
        211,215,218,513,629
    };
    
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: ExtractBlobData \"C:\\Path\\To\\Steam\"");
            System.exit(1);
        }
        String steamDir = args[0];
        final File originalBlob = new File(steamDir, CR_BLOB);
        final File blobfile = createTempCopy(originalBlob);
        BlobFolder bf = RegParser.parseClientRegistry(ParseUtil.mapFile(blobfile));
        ClientRegistry reg = new ClientRegistry(bf);
        final CdrParser cdr = reg.getContentDescriptionRecord();
        //List<Integer> allAppIds = cdr.getAllAppIds();
        FileWriter fw = new FileWriter(new File("BlobData.cs"));
        fw.write("// This file is automatically generated by ExtractBlobData.\r\n");
        fw.write("// To regenerate it, run: ExtractBlobData \"C:\\Path\\To\\Steam\"\r\n");
        fw.write("\r\n");
        fw.write("using System.Collections.Generic;\r\n");
        fw.write("\r\n");
        fw.write("namespace Sledge.Editor.GameFiles\r\n");
        fw.write("{\r\n");
        fw.write("    public static class SteamGames\r\n");
        fw.write("    {\r\n");
        fw.write("        public static List<SteamGame> Games { get; set; }\r\n");
        fw.write("\r\n");
        fw.write("        static SteamGames()\r\n");
        fw.write("        {\r\n");
        fw.write("            Games = new List<SteamGame>\r\n");
        fw.write("                        {\r\n");
        
        PrintData(cdr, GoldsourceGames, fw);
        PrintData(cdr, SourceGames, fw);
        PrintData(cdr, SdkGames, fw);
        
        fw.write("                        };\r\n");
        fw.write("        }\r\n");
        fw.write("    }\r\n");
        fw.write("}\r\n");
        fw.close();
        System.out.println("Done.");
    }

    private static void PrintData(CdrParser cdr, int[] games, FileWriter fw) throws Exception {
        for (int i : games) {
            ArrayList<String> deps = new ArrayList<String>();
            GetDependenciesRecursive(deps, cdr, i);
            fw.write("                            new SteamGame(");
            fw.write(Integer.toString(i));
            fw.write(", \"");
            fw.write(cdr.getAppName(i));
            fw.write("\", new List<string>\r\n");
            fw.write("                                                         {\r\n");
            for (String s : deps) {
                fw.write("                                                             \"");
                fw.write(s);
                fw.write("\",\r\n");
            }
            fw.write("                                                         }),\r\n");
        }
    }
    
    public static void GetDependenciesRecursive(ArrayList<String> list, CdrParser cdr, int appid) throws Exception
    {
        String folderName = cdr.getAppFolderName(appid);
        if (list.contains(folderName)) {
            return;
        }
        list.add(folderName);
        for (CdrParser.AppDependency ad : cdr.getAppDependencies(appid)) {
            if (ad.operatingSystem == null) {
                ad.operatingSystem = "windows";
            }
            if (ad.appid == appid || ad.optional || !ad.operatingSystem.equals("windows")) {
                continue;
            }
            GetDependenciesRecursive(list, cdr, ad.appid);
        }
    }
    
    // Big thanks to Darien Hager's PackBSP and hl2parse libraries for creating this library.
    final static String CR_BLOB = "clientregistry.blob";
    static final String STEAM_APP_DATA = "config/SteamAppData.vdf";
    
    public static File createTempCopy(File source) throws IOException {
        String ext = "blob";
        File dest = File.createTempFile("packbsp_temp_", "." + ext);
        dest.deleteOnExit();
        FileInputStream fis = new FileInputStream(source);
        FileOutputStream fos = new FileOutputStream(dest);
        IOUtils.copy(fis, fos);
        fis.close();
        fos.close();
        return dest;
    }
}
