/*
 * Decompiled with CFR 0.152.
 */
package com.nerius.math.xform;

class Matrix4x4 {
    final double[][] m_entries;

    Matrix4x4(double[][] entries) {
        this.m_entries = entries;
    }

    void transform(double[] arr3D) {
        double x = arr3D[0] * this.m_entries[0][0] + arr3D[1] * this.m_entries[0][1] + arr3D[2] * this.m_entries[0][2] + 1.0 * this.m_entries[0][3];
        double y = arr3D[0] * this.m_entries[1][0] + arr3D[1] * this.m_entries[1][1] + arr3D[2] * this.m_entries[1][2] + 1.0 * this.m_entries[1][3];
        double z = arr3D[0] * this.m_entries[2][0] + arr3D[1] * this.m_entries[2][1] + arr3D[2] * this.m_entries[2][2] + 1.0 * this.m_entries[2][3];
        arr3D[0] = x;
        arr3D[1] = y;
        arr3D[2] = z;
    }

    Matrix4x4 multiply(Matrix4x4 matrix) {
        double[][] newEntries = new double[4][];
        for (int i = 0; i < 4; ++i) {
            newEntries[i] = new double[4];
            for (int j = 0; j < 4; ++j) {
                newEntries[i][j] = this.m_entries[i][0] * matrix.m_entries[0][j] + this.m_entries[i][1] * matrix.m_entries[1][j] + this.m_entries[i][2] * matrix.m_entries[2][j] + this.m_entries[i][3] * matrix.m_entries[3][j];
            }
        }
        return new Matrix4x4(newEntries);
    }
}

