/*
 * Decompiled with CFR 0.152.
 */
package generators;

import com.nerius.math.geom.Point3D;
import com.nerius.math.xform.AxisRotation3D;
import generators.GenerationUtils;

public final class CorkscrewGenerator
extends GenerationUtils {
    public static void main(String[] args) {
        int i;
        Thread.currentThread().setPriority(1);
        int outerRadius = Integer.parseInt(args[0]);
        int innerRadius = Integer.parseInt(args[1]);
        int altitude = Integer.parseInt(args[2]);
        int lip = Integer.parseInt(args[3]);
        int slices = Integer.parseInt(args[4]);
        int outerThickness = Integer.parseInt(args[5]);
        int innerThickness = Integer.parseInt(args[6]);
        boolean adjustForOverlappingCylinderCuts = Boolean.valueOf(args[7]);
        double offsetAngle = Double.parseDouble(args[8]);
        Point3D[][][] mesh = new Point3D[slices + 1][2][2];
        Point3D[] outerCurve = CorkscrewGenerator.generatePipeCurve(outerRadius, slices, 0, 0.0, adjustForOverlappingCylinderCuts ? 1 : 0);
        Point3D[] innerCurve = CorkscrewGenerator.generatePipeCurve(innerRadius, slices, 0, 0.0, adjustForOverlappingCylinderCuts ? 1 : 0);
        AxisRotation3D rot = new AxisRotation3D(1, 1.5707963267948966);
        for (int i2 = 0; i2 <= slices; ++i2) {
            outerCurve[i2] = rot.transform(outerCurve[i2]);
            innerCurve[i2] = rot.transform(innerCurve[i2]);
        }
        if (offsetAngle != 0.0) {
            double radians = Math.PI * offsetAngle / 180.0;
            rot = new AxisRotation3D(4, radians);
            for (i = 0; i <= slices; ++i) {
                outerCurve[i] = rot.transform(outerCurve[i]);
                innerCurve[i] = rot.transform(innerCurve[i]);
            }
        }
        double stepsPerSlice = (double)altitude / (double)slices;
        for (i = 0; i <= slices; ++i) {
            mesh[i][0][0] = new Point3D(outerCurve[i].x, outerCurve[i].y, outerCurve[i].z + (double)i * stepsPerSlice);
            mesh[i][0][1] = new Point3D(outerCurve[i].x, outerCurve[i].y, outerCurve[i].z + (double)i * stepsPerSlice - (double)outerThickness);
            mesh[i][1][0] = new Point3D(innerCurve[i].x, innerCurve[i].y, innerCurve[i].z + (double)i * stepsPerSlice - (double)lip);
            mesh[i][1][1] = new Point3D(innerCurve[i].x, innerCurve[i].y, innerCurve[i].z + (double)i * stepsPerSlice - (double)(innerThickness + lip));
        }
        CorkscrewGenerator.startMap();
        for (int i3 = 0; i3 < slices; ++i3) {
            CorkscrewGenerator.startBrush();
            CorkscrewGenerator.writeFace(mesh[i3][0][0], mesh[i3][1][0], mesh[i3 + 1][0][0]);
            if (outerThickness != 0) {
                CorkscrewGenerator.writeFace(mesh[i3][0][0], mesh[i3][0][1], mesh[i3][1][1]);
            } else {
                CorkscrewGenerator.writeFace(mesh[i3][0][0], mesh[i3][1][1], mesh[i3][1][0]);
            }
            if (outerThickness != 0) {
                CorkscrewGenerator.writeFace(mesh[i3][0][0], mesh[i3 + 1][0][0], mesh[i3 + 1][0][1]);
            }
            if (innerThickness != 0) {
                CorkscrewGenerator.writeFace(mesh[i3 + 1][0][0], mesh[i3][1][0], mesh[i3][1][1]);
            } else {
                CorkscrewGenerator.writeFace(mesh[i3 + 1][0][0], mesh[i3][1][0], mesh[i3 + 1][0][1]);
            }
            CorkscrewGenerator.writeFace(mesh[i3][0][1], mesh[i3 + 1][0][1], mesh[i3][1][1]);
            CorkscrewGenerator.endBrush();
            CorkscrewGenerator.startBrush();
            CorkscrewGenerator.writeFace(mesh[i3 + 1][0][0], mesh[i3][1][0], mesh[i3 + 1][1][0]);
            if (outerThickness != 0) {
                CorkscrewGenerator.writeFace(mesh[i3 + 1][0][0], mesh[i3 + 1][0][1], mesh[i3][1][1]);
            } else {
                CorkscrewGenerator.writeFace(mesh[i3 + 1][0][0], mesh[i3][1][1], mesh[i3][1][0]);
            }
            if (innerThickness != 0) {
                CorkscrewGenerator.writeFace(mesh[i3 + 1][0][0], mesh[i3 + 1][1][0], mesh[i3 + 1][1][1]);
            } else {
                CorkscrewGenerator.writeFace(mesh[i3 + 1][0][0], mesh[i3 + 1][1][0], mesh[i3 + 1][0][1]);
            }
            if (innerThickness != 0) {
                CorkscrewGenerator.writeFace(mesh[i3][1][0], mesh[i3][1][1], mesh[i3 + 1][1][1]);
            }
            CorkscrewGenerator.writeFace(mesh[i3 + 1][0][1], mesh[i3 + 1][1][1], mesh[i3][1][1]);
            CorkscrewGenerator.endBrush();
        }
        CorkscrewGenerator.endMap();
    }
}

