/*
 * Decompiled with CFR 0.152.
 */
package generators;

import com.nerius.math.geom.Point3D;
import com.nerius.math.xform.AxisRotation3D;
import generators.GenerationUtils;

public final class CorkscrewTilesGenerator
extends GenerationUtils {
    public static void main(String[] args) {
        Point3D raisedPt;
        int i;
        Thread.currentThread().setPriority(1);
        int outerRadius = Integer.parseInt(args[0]);
        int innerRadius = Integer.parseInt(args[1]);
        int altitude = Integer.parseInt(args[2]);
        int lip = Integer.parseInt(args[3]);
        int slices = Integer.parseInt(args[4]);
        boolean adjustForOverlappingCylinderCuts = Boolean.valueOf(args[5]);
        boolean reverseTileDirection = Boolean.valueOf(args[6]);
        double offsetAngle = Double.parseDouble(args[7]);
        Point3D[][] mesh = new Point3D[slices + 1][2];
        Point3D[] outerCurve = CorkscrewTilesGenerator.generatePipeCurve(outerRadius, slices, 0, 0.0, adjustForOverlappingCylinderCuts ? 1 : 0);
        Point3D[] innerCurve = CorkscrewTilesGenerator.generatePipeCurve(innerRadius, slices, 0, 0.0, adjustForOverlappingCylinderCuts ? 1 : 0);
        AxisRotation3D rot = new AxisRotation3D(1, 1.5707963267948966);
        for (int i2 = 0; i2 <= slices; ++i2) {
            outerCurve[i2] = rot.transform(outerCurve[i2]);
            innerCurve[i2] = rot.transform(innerCurve[i2]);
        }
        if (offsetAngle != 0.0) {
            double radians = Math.PI * offsetAngle / 180.0;
            rot = new AxisRotation3D(4, radians);
            for (i = 0; i <= slices; ++i) {
                outerCurve[i] = rot.transform(outerCurve[i]);
                innerCurve[i] = rot.transform(innerCurve[i]);
            }
        }
        double stepsPerSlice = (double)altitude / (double)slices;
        for (i = 0; i <= slices; ++i) {
            mesh[i][0] = new Point3D(outerCurve[i].x, outerCurve[i].y, outerCurve[i].z + (double)i * stepsPerSlice);
            mesh[i][1] = new Point3D(innerCurve[i].x, innerCurve[i].y, innerCurve[i].z + (double)i * stepsPerSlice - (double)lip);
        }
        CorkscrewTilesGenerator.startMap();
        if (!reverseTileDirection) {
            for (int i3 = 0; i3 < slices; ++i3) {
                CorkscrewTilesGenerator.startBrush();
                raisedPt = new Point3D(mesh[i3 + 1][0].x, mesh[i3 + 1][0].y, mesh[i3 + 1][0].z + 1.0);
                CorkscrewTilesGenerator.writeFace(raisedPt, mesh[i3][0], mesh[i3][1]);
                CorkscrewTilesGenerator.writeFace(mesh[i3][1], mesh[i3][0], mesh[i3 + 1][0]);
                CorkscrewTilesGenerator.writeFace(mesh[i3][1], mesh[i3 + 1][0], raisedPt);
                CorkscrewTilesGenerator.writeFace(raisedPt, mesh[i3 + 1][0], mesh[i3][0]);
                CorkscrewTilesGenerator.endBrush();
                CorkscrewTilesGenerator.startBrush();
                raisedPt = new Point3D(mesh[i3 + 1][1].x, mesh[i3 + 1][1].y, mesh[i3 + 1][1].z + 1.0);
                CorkscrewTilesGenerator.writeFace(mesh[i3][1], raisedPt, mesh[i3 + 1][0]);
                CorkscrewTilesGenerator.writeFace(mesh[i3 + 1][0], mesh[i3 + 1][1], mesh[i3][1]);
                CorkscrewTilesGenerator.writeFace(mesh[i3][1], mesh[i3 + 1][1], raisedPt);
                CorkscrewTilesGenerator.writeFace(raisedPt, mesh[i3 + 1][1], mesh[i3 + 1][0]);
                CorkscrewTilesGenerator.endBrush();
            }
        } else {
            for (int i4 = 0; i4 < slices; ++i4) {
                CorkscrewTilesGenerator.startBrush();
                raisedPt = new Point3D(mesh[i4][0].x, mesh[i4][0].y, mesh[i4][0].z + 1.0);
                CorkscrewTilesGenerator.writeFace(mesh[i4 + 1][0], raisedPt, mesh[i4][1]);
                CorkscrewTilesGenerator.writeFace(mesh[i4][1], mesh[i4][0], mesh[i4 + 1][0]);
                CorkscrewTilesGenerator.writeFace(raisedPt, mesh[i4][0], mesh[i4][1]);
                CorkscrewTilesGenerator.writeFace(mesh[i4 + 1][0], mesh[i4][0], raisedPt);
                CorkscrewTilesGenerator.endBrush();
                CorkscrewTilesGenerator.startBrush();
                raisedPt = new Point3D(mesh[i4][1].x, mesh[i4][1].y, mesh[i4][1].z + 1.0);
                CorkscrewTilesGenerator.writeFace(raisedPt, mesh[i4 + 1][1], mesh[i4 + 1][0]);
                CorkscrewTilesGenerator.writeFace(mesh[i4 + 1][0], mesh[i4 + 1][1], mesh[i4][1]);
                CorkscrewTilesGenerator.writeFace(raisedPt, mesh[i4][1], mesh[i4 + 1][1]);
                CorkscrewTilesGenerator.writeFace(mesh[i4 + 1][0], mesh[i4][1], raisedPt);
                CorkscrewTilesGenerator.endBrush();
            }
        }
        CorkscrewTilesGenerator.endMap();
    }
}

