/*
 * Decompiled with CFR 0.152.
 */
package main;

import generators.FunnelGenerator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import main.Config;
import tools.MapFactory;

public class FunnelGeneratorGUI
extends JFrame {
    private Config configuration;
    private int topRadius = 640;
    private int bottomRadius = 512;
    private Color shaded = new Color(200, 200, 200);
    private Color normal = this.getBackground();
    private String topRadiusTitle = "topRadius";
    private String topRadiusDescription = "The radius of the top of the funnel. You should probably have this be greater than bottomRadius.";
    private String bottomRadiusTitle = "bottomRadius";
    private String bottomRadiusDescription = "The radius of the bottom of the funnel. You should probably have this be less than topRadius. This radius may be zero. ";
    private String heightTitle = "height";
    private String heightDescription = "The difference in height between the top and bottom of the funnel. Unless you know what you are doing, this value should be positive.";
    private String slicesTitle = "slices";
    private String slicesDescription = "The number of slices to chop the top circumference and the bottom circumference into. The funnel structure ends up having slices * 2 triangular faces making up the funnel surface.";
    private String crossSectionTitle = "crossSection";
    private String crossSectionDescription = "Unless extendDownInsteadOfSquare is checked, this specifies the length of the square cross section of the total structure making up a quarter of a funnel. If extendDownInsteadOfSquare is checked, the cross section takes on a slightly different meaning, which is the distance from the \"top\" of the funnel to the very bottom of the base. Note: if overlapping brushes are being generated, you will need to set this to a large value relative to the radius values. ";
    private String offsetTopInsteadOfBottomTitle = "offsetTopInsteadOfBottom";
    private String offsetTopInsteadOfBottomDescription = "To make the funnel, either the top or the bottom circumference must be rotated counter-clockwise by half a slice, so that triangles can be created on the surface. Normally, the bottom circumference is rotated by this amount. use this flag to rotate the top circumference instead.";
    private String extendDownInsteadOfSquareTitle = "extendDownInsteadOfSquare";
    private String extendDownInsteadOfSquareDescription = "Project the triangular faces of the funnel downwards to make the brushes. Normally, the faces are projected in the +x and +y directions. ";
    private String generateOnlySeamTitle = "generateOnlySeam";
    private String generateOnlySeamDescription = "Generate only the last brush. Useful for making seams.";
    private String adjustSeamForJoiningTitle = "adjustSeamForJoining";
    private String adjustSeamForJoiningDescription = "Adjust the seam brush if it is to be joined to another structure such as a slanted wall. ";
    private String opNormalTitle = "Generate normal non-overlapping brushes";
    private String opNormalDescription = "Generates ordinary brushes. To make a funnel wall to fling you around at high speeds, you will have to generate overlapping brushes in order to prevent \"bouncing\". Another purpose for normal brushes is to define the visual component of a structure, for example by using surfaceparm nonsolid. ";
    private String opOverlappingTitle = "Generate overlapping brushes";
    private String opOverlappingDescription = "Overlapping brushes are useful for making funnels such that the player doesn't \"bounce\" off the surface when flying against the funnel wall. However, it is not advised to texture the overlapping brush faces with drawn textures. Instead, apply [slick] caulk to all of the overlapping brushes, then superimpose a set of normal non-overlapping brushes that have surfaceparm nonsolid. NOTE: If you are generating overlapping brushes make sure that crossSection is very high relative to the other values such as radius. When you are done generating overlapping brushes, you will likely want to cut everything off that is above z = 0 and everything that is below z = -height. ";
    private String offsetAngleTitle = "Offset Angle";
    private String offsetAngleDescription = "The angle, in degrees, by which to rotate the funnel counter-clockwise. This only applies if extendDownInsteadOfSquare is true.";
    private JCheckBox adjustSeamForJoining;
    private JPanel adjustSeamForJoiningPanel;
    private JPanel bottomRadiusPanel;
    private JPanel calculatePanel;
    private JTextArea calculatorDescription;
    private JPanel calculatorDescriptionPanel;
    private JPanel calculatorPanel;
    private JPanel crossSectionPanel;
    private JTextArea description;
    private JPanel descriptionPanel;
    private JScrollPane descriptionScrollPane;
    private JLabel descriptionTitle;
    private JCheckBox extendDownInsteadOfSquare;
    private JPanel extendDownInsteadOfSquarePanel;
    private JDialog funnelNote;
    private JButton generate;
    private JCheckBox generateOnlySeam;
    private JPanel generateOnlySeamPanel;
    private JPanel heightPanel;
    private JLabel icon;
    private JPanel iconPanel;
    private JTextField inBottomRadius;
    private JTextField inCrossSection;
    private JTextField inHeight;
    private JTextField inOffsetAngle;
    private JTextField inSlices;
    private JTextField inTopRadius;
    private JMenuItem interestingValuesNote;
    private JLabel labBottomRadius;
    private JLabel labCrossSection;
    private JLabel labHeight;
    private JLabel labOffsetAngle;
    private JLabel labSlicesSlope;
    private JLabel labTopRadius;
    private JMenuBar menu;
    private JPanel normalOptionPanel;
    private JMenu note;
    private JPanel offsetAnglePanel;
    private JCheckBox offsetTopInsteadOfBottom;
    private JPanel offsetTopInsteadOfBottomPanel;
    private JRadioButton opNormal;
    private JRadioButton opOverlapping;
    private ButtonGroup options;
    private JPanel optionsPanel;
    private JPanel overlappingBrushOptionPanel;
    private JScrollPane scrollPane;
    private JPanel slicesPanel;
    private JTextArea status;
    private JPanel statusPanel;
    private JScrollPane statusScrollPane;
    private JLabel subtitle;
    private JPanel subtitlePanel;
    private JPanel topRadiusPanel;
    private JButton useInterestingValues;
    private JPanel valuesPanel;
    private JPanel viewPanel;

    public FunnelGeneratorGUI(Config configuration) {
        this.initComponents();
        this.configuration = configuration;
        Dimension frameSize = this.getSize();
        int frameHeight = frameSize.height;
        int frameWidth = frameSize.width;
        if (frameHeight > configuration.getScreenHeight()) {
            this.setSize(frameWidth, configuration.getScreenHeight());
        }
    }

    private void initComponents() {
        this.options = new ButtonGroup();
        this.funnelNote = new JDialog();
        this.calculatorPanel = new JPanel();
        this.calculatePanel = new JPanel();
        this.useInterestingValues = new JButton();
        this.calculatorDescriptionPanel = new JPanel();
        this.calculatorDescription = new JTextArea();
        this.scrollPane = new JScrollPane();
        this.viewPanel = new JPanel();
        this.descriptionPanel = new JPanel();
        this.descriptionScrollPane = new JScrollPane();
        this.description = new JTextArea();
        this.descriptionTitle = new JLabel();
        this.subtitlePanel = new JPanel();
        this.subtitle = new JLabel();
        this.statusPanel = new JPanel();
        this.generate = new JButton();
        this.statusScrollPane = new JScrollPane();
        this.status = new JTextArea();
        this.valuesPanel = new JPanel();
        this.topRadiusPanel = new JPanel();
        this.labTopRadius = new JLabel();
        this.inTopRadius = new JTextField();
        this.crossSectionPanel = new JPanel();
        this.labCrossSection = new JLabel();
        this.inCrossSection = new JTextField();
        this.heightPanel = new JPanel();
        this.labHeight = new JLabel();
        this.inHeight = new JTextField();
        this.slicesPanel = new JPanel();
        this.labSlicesSlope = new JLabel();
        this.inSlices = new JTextField();
        this.extendDownInsteadOfSquarePanel = new JPanel();
        this.extendDownInsteadOfSquare = new JCheckBox();
        this.offsetTopInsteadOfBottomPanel = new JPanel();
        this.offsetTopInsteadOfBottom = new JCheckBox();
        this.bottomRadiusPanel = new JPanel();
        this.labBottomRadius = new JLabel();
        this.inBottomRadius = new JTextField();
        this.adjustSeamForJoiningPanel = new JPanel();
        this.adjustSeamForJoining = new JCheckBox();
        this.generateOnlySeamPanel = new JPanel();
        this.generateOnlySeam = new JCheckBox();
        this.offsetAnglePanel = new JPanel();
        this.labOffsetAngle = new JLabel();
        this.inOffsetAngle = new JTextField();
        this.iconPanel = new JPanel();
        this.icon = new JLabel();
        this.optionsPanel = new JPanel();
        this.normalOptionPanel = new JPanel();
        this.opNormal = new JRadioButton();
        this.overlappingBrushOptionPanel = new JPanel();
        this.opOverlapping = new JRadioButton();
        this.menu = new JMenuBar();
        this.note = new JMenu();
        this.interestingValuesNote = new JMenuItem();
        this.funnelNote.setTitle("Note on Interesting Values");
        this.funnelNote.setMinimumSize(new Dimension(330, 372));
        this.useInterestingValues.setText("Try these values");
        this.useInterestingValues.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FunnelGeneratorGUI.this.useInterestingValuesActionPerformed(evt);
            }
        });
        GroupLayout calculatePanelLayout = new GroupLayout(this.calculatePanel);
        this.calculatePanel.setLayout(calculatePanelLayout);
        calculatePanelLayout.setHorizontalGroup(calculatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, calculatePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.useInterestingValues, -1, -1, Short.MAX_VALUE).addContainerGap()));
        calculatePanelLayout.setVerticalGroup(calculatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, calculatePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.useInterestingValues).addContainerGap()));
        this.calculatorDescription.setEditable(false);
        this.calculatorDescription.setBackground(new Color(240, 240, 240));
        this.calculatorDescription.setColumns(20);
        this.calculatorDescription.setLineWrap(true);
        this.calculatorDescription.setRows(5);
        this.calculatorDescription.setText(" Note that it is possible to create interesting shapes that are not exactly funnels if you know what you are doing. For example, try the following parameters:\ntopRadius:\t768\nbottomRadius: 256\nheight:\t-512\nslices:\t16\ncrossSection:\t128\nextendDownInsteadOfSquare: checked");
        this.calculatorDescription.setWrapStyleWord(true);
        GroupLayout calculatorDescriptionPanelLayout = new GroupLayout(this.calculatorDescriptionPanel);
        this.calculatorDescriptionPanel.setLayout(calculatorDescriptionPanelLayout);
        calculatorDescriptionPanelLayout.setHorizontalGroup(calculatorDescriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculatorDescriptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.calculatorDescription).addContainerGap()));
        calculatorDescriptionPanelLayout.setVerticalGroup(calculatorDescriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, calculatorDescriptionPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.calculatorDescription, -2, 196, -2).addGap(172, 172, 172)));
        GroupLayout calculatorPanelLayout = new GroupLayout(this.calculatorPanel);
        this.calculatorPanel.setLayout(calculatorPanelLayout);
        calculatorPanelLayout.setHorizontalGroup(calculatorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculatorPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.calculatorDescriptionPanel, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(calculatorPanelLayout.createSequentialGroup().addGap(106, 106, 106).addComponent(this.calculatePanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        calculatorPanelLayout.setVerticalGroup(calculatorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculatorPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.calculatorDescriptionPanel, -2, 222, -2).addGap(18, 18, Short.MAX_VALUE).addComponent(this.calculatePanel, -2, -1, -2).addContainerGap()));
        GroupLayout funnelNoteLayout = new GroupLayout(this.funnelNote.getContentPane());
        this.funnelNote.getContentPane().setLayout(funnelNoteLayout);
        funnelNoteLayout.setHorizontalGroup(funnelNoteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(funnelNoteLayout.createSequentialGroup().addContainerGap().addComponent(this.calculatorPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        funnelNoteLayout.setVerticalGroup(funnelNoteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(funnelNoteLayout.createSequentialGroup().addContainerGap().addComponent(this.calculatorPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.setTitle("Funnel Generator");
        this.setLocationByPlatform(true);
        this.description.setEditable(false);
        this.description.setColumns(20);
        this.description.setLineWrap(true);
        this.description.setRows(5);
        this.description.setWrapStyleWord(true);
        this.description.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.description.setFocusable(false);
        this.description.setMargin(new Insets(5, 5, 5, 5));
        this.descriptionScrollPane.setViewportView(this.description);
        this.descriptionTitle.setHorizontalAlignment(0);
        GroupLayout descriptionPanelLayout = new GroupLayout(this.descriptionPanel);
        this.descriptionPanel.setLayout(descriptionPanelLayout);
        descriptionPanelLayout.setHorizontalGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, descriptionPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.descriptionTitle, -1, -1, Short.MAX_VALUE).addComponent(this.descriptionScrollPane, -1, 297, Short.MAX_VALUE)).addContainerGap()));
        descriptionPanelLayout.setVerticalGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, descriptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.descriptionTitle, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.descriptionScrollPane, -1, 258, Short.MAX_VALUE).addContainerGap()));
        this.subtitle.setHorizontalAlignment(0);
        this.subtitle.setText("Generates a quarter of a funnel as a .map file to be opened in GtkRadiant.");
        GroupLayout subtitlePanelLayout = new GroupLayout(this.subtitlePanel);
        this.subtitlePanel.setLayout(subtitlePanelLayout);
        subtitlePanelLayout.setHorizontalGroup(subtitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(subtitlePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.subtitle, -1, -1, Short.MAX_VALUE)));
        subtitlePanelLayout.setVerticalGroup(subtitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.subtitle, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.generate.setText("Generate");
        this.generate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FunnelGeneratorGUI.this.generateActionPerformed(evt);
            }
        });
        this.status.setEditable(false);
        this.status.setColumns(20);
        this.status.setRows(5);
        this.status.setFocusable(false);
        this.statusScrollPane.setViewportView(this.status);
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusScrollPane).addGap(18, 18, 18).addComponent(this.generate).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.generate).addComponent(this.statusScrollPane, -2, 40, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.topRadiusPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FunnelGeneratorGUI.this.topRadiusPanelFocusGained(evt);
            }
        });
        this.labTopRadius.setLabelFor(this.inTopRadius);
        this.labTopRadius.setText("topRadius:");
        this.inTopRadius.setText("640");
        this.inTopRadius.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FunnelGeneratorGUI.this.inTopRadiusActionPerformed(evt);
            }
        });
        this.inTopRadius.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FunnelGeneratorGUI.this.inTopRadiusFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                FunnelGeneratorGUI.this.inTopRadiusFocusLost(evt);
            }
        });
        GroupLayout topRadiusPanelLayout = new GroupLayout(this.topRadiusPanel);
        this.topRadiusPanel.setLayout(topRadiusPanelLayout);
        topRadiusPanelLayout.setHorizontalGroup(topRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(topRadiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labTopRadius).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inTopRadius, -2, 64, -2).addContainerGap()));
        topRadiusPanelLayout.setVerticalGroup(topRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, topRadiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(topRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labTopRadius).addComponent(this.inTopRadius, -2, -1, -2)).addContainerGap()));
        this.labCrossSection.setLabelFor(this.inCrossSection);
        this.labCrossSection.setText("crossSection:");
        this.inCrossSection.setText("1024");
        this.inCrossSection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FunnelGeneratorGUI.this.inCrossSectionActionPerformed(evt);
            }
        });
        this.inCrossSection.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FunnelGeneratorGUI.this.inCrossSectionFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                FunnelGeneratorGUI.this.inCrossSectionFocusLost(evt);
            }
        });
        GroupLayout crossSectionPanelLayout = new GroupLayout(this.crossSectionPanel);
        this.crossSectionPanel.setLayout(crossSectionPanelLayout);
        crossSectionPanelLayout.setHorizontalGroup(crossSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(crossSectionPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labCrossSection).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inCrossSection, -2, 64, -2).addContainerGap()));
        crossSectionPanelLayout.setVerticalGroup(crossSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, crossSectionPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(crossSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labCrossSection).addComponent(this.inCrossSection, -2, -1, -2)).addContainerGap()));
        this.labHeight.setLabelFor(this.inHeight);
        this.labHeight.setText("height:");
        this.inHeight.setText("256");
        this.inHeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FunnelGeneratorGUI.this.inHeightActionPerformed(evt);
            }
        });
        this.inHeight.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FunnelGeneratorGUI.this.inHeightFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                FunnelGeneratorGUI.this.inHeightFocusLost(evt);
            }
        });
        GroupLayout heightPanelLayout = new GroupLayout(this.heightPanel);
        this.heightPanel.setLayout(heightPanelLayout);
        heightPanelLayout.setHorizontalGroup(heightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(heightPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labHeight).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inHeight, -2, 64, -2).addContainerGap()));
        heightPanelLayout.setVerticalGroup(heightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, heightPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(heightPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labHeight).addComponent(this.inHeight, -2, -1, -2)).addContainerGap()));
        this.labSlicesSlope.setLabelFor(this.inSlices);
        this.labSlicesSlope.setText("slices:");
        this.inSlices.setText("16");
        this.inSlices.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FunnelGeneratorGUI.this.inSlicesActionPerformed(evt);
            }
        });
        this.inSlices.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FunnelGeneratorGUI.this.inSlicesFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                FunnelGeneratorGUI.this.inSlicesFocusLost(evt);
            }
        });
        GroupLayout slicesPanelLayout = new GroupLayout(this.slicesPanel);
        this.slicesPanel.setLayout(slicesPanelLayout);
        slicesPanelLayout.setHorizontalGroup(slicesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(slicesPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labSlicesSlope).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inSlices, -2, 64, -2).addContainerGap()));
        slicesPanelLayout.setVerticalGroup(slicesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(slicesPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(slicesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labSlicesSlope).addComponent(this.inSlices, -2, -1, -2))));
        this.extendDownInsteadOfSquare.setText("extendDownInsteadOfSquare");
        this.extendDownInsteadOfSquare.setHorizontalAlignment(11);
        this.extendDownInsteadOfSquare.setHorizontalTextPosition(10);
        this.extendDownInsteadOfSquare.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FunnelGeneratorGUI.this.extendDownInsteadOfSquareFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                FunnelGeneratorGUI.this.extendDownInsteadOfSquareFocusLost(evt);
            }
        });
        GroupLayout extendDownInsteadOfSquarePanelLayout = new GroupLayout(this.extendDownInsteadOfSquarePanel);
        this.extendDownInsteadOfSquarePanel.setLayout(extendDownInsteadOfSquarePanelLayout);
        extendDownInsteadOfSquarePanelLayout.setHorizontalGroup(extendDownInsteadOfSquarePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(extendDownInsteadOfSquarePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.extendDownInsteadOfSquare, -1, -1, Short.MAX_VALUE).addContainerGap()));
        extendDownInsteadOfSquarePanelLayout.setVerticalGroup(extendDownInsteadOfSquarePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, extendDownInsteadOfSquarePanelLayout.createSequentialGroup().addGap(0, 12, Short.MAX_VALUE).addComponent(this.extendDownInsteadOfSquare, -2, 23, -2)));
        this.offsetTopInsteadOfBottom.setText("offsetTopInsteadOfBottom");
        this.offsetTopInsteadOfBottom.setHorizontalAlignment(11);
        this.offsetTopInsteadOfBottom.setHorizontalTextPosition(10);
        this.offsetTopInsteadOfBottom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FunnelGeneratorGUI.this.offsetTopInsteadOfBottomActionPerformed(evt);
            }
        });
        this.offsetTopInsteadOfBottom.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FunnelGeneratorGUI.this.offsetTopInsteadOfBottomFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                FunnelGeneratorGUI.this.offsetTopInsteadOfBottomFocusLost(evt);
            }
        });
        GroupLayout offsetTopInsteadOfBottomPanelLayout = new GroupLayout(this.offsetTopInsteadOfBottomPanel);
        this.offsetTopInsteadOfBottomPanel.setLayout(offsetTopInsteadOfBottomPanelLayout);
        offsetTopInsteadOfBottomPanelLayout.setHorizontalGroup(offsetTopInsteadOfBottomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(offsetTopInsteadOfBottomPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.offsetTopInsteadOfBottom, -1, -1, Short.MAX_VALUE).addContainerGap()));
        offsetTopInsteadOfBottomPanelLayout.setVerticalGroup(offsetTopInsteadOfBottomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, offsetTopInsteadOfBottomPanelLayout.createSequentialGroup().addGap(0, 10, Short.MAX_VALUE).addComponent(this.offsetTopInsteadOfBottom, -2, 23, -2)));
        this.bottomRadiusPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FunnelGeneratorGUI.this.bottomRadiusPanelFocusGained(evt);
            }
        });
        this.labBottomRadius.setLabelFor(this.inTopRadius);
        this.labBottomRadius.setText("bottomRadius:");
        this.inBottomRadius.setText("512");
        this.inBottomRadius.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FunnelGeneratorGUI.this.inBottomRadiusActionPerformed(evt);
            }
        });
        this.inBottomRadius.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FunnelGeneratorGUI.this.inBottomRadiusFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                FunnelGeneratorGUI.this.inBottomRadiusFocusLost(evt);
            }
        });
        GroupLayout bottomRadiusPanelLayout = new GroupLayout(this.bottomRadiusPanel);
        this.bottomRadiusPanel.setLayout(bottomRadiusPanelLayout);
        bottomRadiusPanelLayout.setHorizontalGroup(bottomRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bottomRadiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labBottomRadius).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inBottomRadius, -2, 64, -2).addContainerGap()));
        bottomRadiusPanelLayout.setVerticalGroup(bottomRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, bottomRadiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(bottomRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labBottomRadius).addComponent(this.inBottomRadius, -2, -1, -2)).addContainerGap()));
        this.adjustSeamForJoining.setText("adjustSeamForJoining");
        this.adjustSeamForJoining.setHorizontalAlignment(11);
        this.adjustSeamForJoining.setHorizontalTextPosition(10);
        this.adjustSeamForJoining.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FunnelGeneratorGUI.this.adjustSeamForJoiningFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                FunnelGeneratorGUI.this.adjustSeamForJoiningFocusLost(evt);
            }
        });
        GroupLayout adjustSeamForJoiningPanelLayout = new GroupLayout(this.adjustSeamForJoiningPanel);
        this.adjustSeamForJoiningPanel.setLayout(adjustSeamForJoiningPanelLayout);
        adjustSeamForJoiningPanelLayout.setHorizontalGroup(adjustSeamForJoiningPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(adjustSeamForJoiningPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.adjustSeamForJoining, -1, -1, Short.MAX_VALUE).addContainerGap()));
        adjustSeamForJoiningPanelLayout.setVerticalGroup(adjustSeamForJoiningPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, adjustSeamForJoiningPanelLayout.createSequentialGroup().addGap(0, 6, Short.MAX_VALUE).addComponent(this.adjustSeamForJoining, -2, 23, -2)));
        this.generateOnlySeam.setText("generateOnlySeam");
        this.generateOnlySeam.setHorizontalAlignment(11);
        this.generateOnlySeam.setHorizontalTextPosition(10);
        this.generateOnlySeam.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FunnelGeneratorGUI.this.generateOnlySeamActionPerformed(evt);
            }
        });
        this.generateOnlySeam.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FunnelGeneratorGUI.this.generateOnlySeamFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                FunnelGeneratorGUI.this.generateOnlySeamFocusLost(evt);
            }
        });
        GroupLayout generateOnlySeamPanelLayout = new GroupLayout(this.generateOnlySeamPanel);
        this.generateOnlySeamPanel.setLayout(generateOnlySeamPanelLayout);
        generateOnlySeamPanelLayout.setHorizontalGroup(generateOnlySeamPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, generateOnlySeamPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.generateOnlySeam, -1, -1, Short.MAX_VALUE).addContainerGap()));
        generateOnlySeamPanelLayout.setVerticalGroup(generateOnlySeamPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, generateOnlySeamPanelLayout.createSequentialGroup().addGap(0, 6, Short.MAX_VALUE).addComponent(this.generateOnlySeam, -2, 23, -2)));
        this.labOffsetAngle.setLabelFor(this.inCrossSection);
        this.labOffsetAngle.setText("offsetAngle:");
        this.inOffsetAngle.setText("0.0");
        this.inOffsetAngle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FunnelGeneratorGUI.this.inOffsetAngleActionPerformed(evt);
            }
        });
        this.inOffsetAngle.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FunnelGeneratorGUI.this.inOffsetAngleFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                FunnelGeneratorGUI.this.inOffsetAngleFocusLost(evt);
            }
        });
        GroupLayout offsetAnglePanelLayout = new GroupLayout(this.offsetAnglePanel);
        this.offsetAnglePanel.setLayout(offsetAnglePanelLayout);
        offsetAnglePanelLayout.setHorizontalGroup(offsetAnglePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(offsetAnglePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labOffsetAngle).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inOffsetAngle, -2, 64, -2).addContainerGap()));
        offsetAnglePanelLayout.setVerticalGroup(offsetAnglePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, offsetAnglePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(offsetAnglePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labOffsetAngle).addComponent(this.inOffsetAngle, -2, -1, -2)).addContainerGap()));
        GroupLayout valuesPanelLayout = new GroupLayout(this.valuesPanel);
        this.valuesPanel.setLayout(valuesPanelLayout);
        valuesPanelLayout.setHorizontalGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(valuesPanelLayout.createSequentialGroup().addContainerGap().addGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(valuesPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.bottomRadiusPanel, -1, -1, Short.MAX_VALUE).addComponent(this.adjustSeamForJoiningPanel, -1, -1, Short.MAX_VALUE).addComponent(this.topRadiusPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.crossSectionPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.slicesPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.heightPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.offsetTopInsteadOfBottomPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.extendDownInsteadOfSquarePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.generateOnlySeamPanel, -1, -1, Short.MAX_VALUE))).addComponent(this.offsetAnglePanel, -1, -1, Short.MAX_VALUE))));
        valuesPanelLayout.setVerticalGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(valuesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.topRadiusPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bottomRadiusPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.heightPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.slicesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.crossSectionPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.offsetTopInsteadOfBottomPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.extendDownInsteadOfSquarePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.generateOnlySeamPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.adjustSeamForJoiningPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.offsetAnglePanel, -2, 32, -2).addContainerGap()));
        this.icon.setHorizontalAlignment(0);
        this.icon.setIcon(new ImageIcon(this.getClass().getResource("/main/funnel.png")));
        this.icon.setFocusable(false);
        GroupLayout iconPanelLayout = new GroupLayout(this.iconPanel);
        this.iconPanel.setLayout(iconPanelLayout);
        iconPanelLayout.setHorizontalGroup(iconPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(iconPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.icon, -1, -1, Short.MAX_VALUE).addContainerGap()));
        iconPanelLayout.setVerticalGroup(iconPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, iconPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.icon, -2, 196, -2)));
        this.normalOptionPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                FunnelGeneratorGUI.this.normalOptionPanelFocusLost(evt);
            }
        });
        this.options.add(this.opNormal);
        this.opNormal.setSelected(true);
        this.opNormal.setText("generate normal non-overlapping brushes");
        this.opNormal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FunnelGeneratorGUI.this.opNormalActionPerformed(evt);
            }
        });
        this.opNormal.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FunnelGeneratorGUI.this.opNormalFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                FunnelGeneratorGUI.this.opNormalFocusLost(evt);
            }
        });
        GroupLayout normalOptionPanelLayout = new GroupLayout(this.normalOptionPanel);
        this.normalOptionPanel.setLayout(normalOptionPanelLayout);
        normalOptionPanelLayout.setHorizontalGroup(normalOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(normalOptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.opNormal).addContainerGap(-1, Short.MAX_VALUE)));
        normalOptionPanelLayout.setVerticalGroup(normalOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.opNormal, -1, 27, Short.MAX_VALUE));
        this.options.add(this.opOverlapping);
        this.opOverlapping.setText("generate overlapping brushes");
        this.opOverlapping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FunnelGeneratorGUI.this.opOverlappingActionPerformed(evt);
            }
        });
        this.opOverlapping.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                FunnelGeneratorGUI.this.opOverlappingFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                FunnelGeneratorGUI.this.opOverlappingFocusLost(evt);
            }
        });
        GroupLayout overlappingBrushOptionPanelLayout = new GroupLayout(this.overlappingBrushOptionPanel);
        this.overlappingBrushOptionPanel.setLayout(overlappingBrushOptionPanelLayout);
        overlappingBrushOptionPanelLayout.setHorizontalGroup(overlappingBrushOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(overlappingBrushOptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.opOverlapping).addContainerGap(-1, Short.MAX_VALUE)));
        overlappingBrushOptionPanelLayout.setVerticalGroup(overlappingBrushOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.opOverlapping));
        GroupLayout optionsPanelLayout = new GroupLayout(this.optionsPanel);
        this.optionsPanel.setLayout(optionsPanelLayout);
        optionsPanelLayout.setHorizontalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, optionsPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.overlappingBrushOptionPanel, -1, -1, Short.MAX_VALUE).addComponent(this.normalOptionPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        optionsPanelLayout.setVerticalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.normalOptionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.overlappingBrushOptionPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout viewPanelLayout = new GroupLayout(this.viewPanel);
        this.viewPanel.setLayout(viewPanelLayout);
        viewPanelLayout.setHorizontalGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(viewPanelLayout.createSequentialGroup().addContainerGap().addGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(viewPanelLayout.createSequentialGroup().addComponent(this.optionsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.iconPanel, -2, -1, -2)).addComponent(this.subtitlePanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.statusPanel, -1, -1, Short.MAX_VALUE).addGroup(viewPanelLayout.createSequentialGroup().addComponent(this.valuesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.descriptionPanel, -2, -1, -2))).addContainerGap(15, Short.MAX_VALUE)));
        viewPanelLayout.setVerticalGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(viewPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.subtitlePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(viewPanelLayout.createSequentialGroup().addComponent(this.descriptionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.iconPanel, -2, -1, -2)).addGroup(viewPanelLayout.createSequentialGroup().addComponent(this.valuesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.optionsPanel, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.scrollPane.setViewportView(this.viewPanel);
        this.note.setText("Note");
        this.interestingValuesNote.setText("Note on interesting values");
        this.interestingValuesNote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FunnelGeneratorGUI.this.interestingValuesNoteActionPerformed(evt);
            }
        });
        this.note.add(this.interestingValuesNote);
        this.menu.add(this.note);
        this.setJMenuBar(this.menu);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.scrollPane)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -2, -1, -2));
        this.pack();
    }

    private void inTopRadiusFocusGained(FocusEvent evt) {
        this.topRadiusPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.topRadiusTitle);
        this.description.setText(this.topRadiusDescription);
    }

    private void inTopRadiusFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void topRadiusPanelFocusGained(FocusEvent evt) {
    }

    private void inCrossSectionFocusGained(FocusEvent evt) {
        this.crossSectionPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.crossSectionTitle);
        this.description.setText(this.crossSectionDescription);
    }

    private void inCrossSectionFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inHeightFocusGained(FocusEvent evt) {
        this.heightPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.heightTitle);
        this.description.setText(this.heightDescription);
    }

    private void inHeightFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void offsetTopInsteadOfBottomFocusGained(FocusEvent evt) {
        this.offsetTopInsteadOfBottomPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.offsetTopInsteadOfBottomTitle);
        this.description.setText(this.offsetTopInsteadOfBottomDescription);
    }

    private void offsetTopInsteadOfBottomFocusLost(FocusEvent evt) {
        this.offsetTopInsteadOfBottomPanel.setBackground(this.normal);
    }

    private void generateActionPerformed(ActionEvent evt) {
        this.generate.setEnabled(false);
        String[] args = new String[]{this.inTopRadius.getText(), this.inBottomRadius.getText(), this.inHeight.getText(), this.inSlices.getText(), this.inCrossSection.getText(), Boolean.toString(this.offsetTopInsteadOfBottom.isSelected()), Boolean.toString(this.extendDownInsteadOfSquare.isSelected()), Boolean.toString(this.opOverlapping.isSelected()), Boolean.toString(this.generateOnlySeam.isSelected()), Boolean.toString(this.adjustSeamForJoining.isSelected()), this.inOffsetAngle.getText()};
        this.status.setText("Generating funnel...");
        FunnelGenerator.main(args);
        this.status.setText("Generated - select save file name and location");
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Quake Map File (.map)", "map");
        chooser.setFileFilter(filter);
        File saveFile = null;
        String filename = null;
        boolean save = true;
        while (save) {
            int returnValue;
            if (this.configuration.getWorkingDirectory() != null && this.configuration.getWorkingDirectory().isDirectory()) {
                chooser.setCurrentDirectory(this.configuration.getWorkingDirectory());
            }
            if ((returnValue = chooser.showSaveDialog(this)) == 1 || returnValue == -1) {
                save = false;
            } else {
                saveFile = chooser.getSelectedFile();
                filename = saveFile.getAbsolutePath();
                if (!filename.endsWith(".map")) {
                    filename = filename + ".map";
                }
                if ((saveFile = new File(filename)).exists()) {
                    Object[] buttons = new Object[]{"Cancel", "No", "Yes"};
                    int response = JOptionPane.showOptionDialog(this, "Overwrite " + filename + " ?", "Confirm Overwrite", 2, 0, null, buttons, buttons[1]);
                    if (response == 1) continue;
                    if (response == 0) {
                        save = false;
                    }
                }
            }
            if (save) {
                this.status.setText("Saving...");
                MapFactory.saveText(filename);
                this.statusPanel.setBackground(Color.green);
                this.status.setText("Save successful\n" + filename);
                this.configuration.setWorkingDirectory(saveFile.getParentFile());
                save = false;
                continue;
            }
            this.status.setText("Save Cancelled");
        }
    }

    private void offsetTopInsteadOfBottomActionPerformed(ActionEvent evt) {
    }

    private void opOverlappingFocusLost(FocusEvent evt) {
        this.overlappingBrushOptionPanel.setBackground(this.normal);
        this.checkGenerateOK();
    }

    private void opOverlappingFocusGained(FocusEvent evt) {
        this.overlappingBrushOptionPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.opOverlappingTitle);
        this.description.setText(this.opOverlappingDescription);
    }

    private void opOverlappingActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void normalOptionPanelFocusLost(FocusEvent evt) {
    }

    private void opNormalFocusLost(FocusEvent evt) {
        this.normalOptionPanel.setBackground(this.normal);
        this.checkGenerateOK();
    }

    private void opNormalFocusGained(FocusEvent evt) {
        this.checkGenerateOK();
        this.normalOptionPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.opNormalTitle);
        this.description.setText(this.opNormalDescription);
    }

    private void opNormalActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void extendDownInsteadOfSquareFocusGained(FocusEvent evt) {
        this.extendDownInsteadOfSquarePanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.extendDownInsteadOfSquareTitle);
        this.description.setText(this.extendDownInsteadOfSquareDescription);
    }

    private void extendDownInsteadOfSquareFocusLost(FocusEvent evt) {
        this.extendDownInsteadOfSquarePanel.setBackground(this.normal);
    }

    private void inBottomRadiusFocusGained(FocusEvent evt) {
        this.bottomRadiusPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.bottomRadiusTitle);
        this.description.setText(this.bottomRadiusDescription);
    }

    private void inBottomRadiusFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void bottomRadiusPanelFocusGained(FocusEvent evt) {
    }

    private void adjustSeamForJoiningFocusGained(FocusEvent evt) {
        this.adjustSeamForJoiningPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.adjustSeamForJoiningTitle);
        this.description.setText(this.adjustSeamForJoiningDescription);
    }

    private void adjustSeamForJoiningFocusLost(FocusEvent evt) {
        this.adjustSeamForJoiningPanel.setBackground(this.normal);
    }

    private void generateOnlySeamFocusGained(FocusEvent evt) {
        this.generateOnlySeamPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.generateOnlySeamTitle);
        this.description.setText(this.generateOnlySeamDescription);
    }

    private void generateOnlySeamFocusLost(FocusEvent evt) {
        this.generateOnlySeamPanel.setBackground(this.normal);
    }

    private void inSlicesFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inSlicesFocusGained(FocusEvent evt) {
        this.slicesPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.slicesTitle);
        this.description.setText(this.slicesDescription);
    }

    private void generateOnlySeamActionPerformed(ActionEvent evt) {
    }

    private void inOffsetAngleFocusGained(FocusEvent evt) {
        this.offsetAnglePanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.offsetAngleTitle);
        this.description.setText(this.offsetAngleDescription);
    }

    private void inOffsetAngleFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inOffsetAngleActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inCrossSectionActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inSlicesActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inHeightActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inBottomRadiusActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inTopRadiusActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void useInterestingValuesActionPerformed(ActionEvent evt) {
        this.inTopRadius.setText("768");
        this.inBottomRadius.setText("256");
        this.inHeight.setText("-512");
        this.inSlices.setText("16");
        this.inCrossSection.setText("128");
        this.extendDownInsteadOfSquare.setSelected(true);
        this.checkGenerateOK();
    }

    private void interestingValuesNoteActionPerformed(ActionEvent evt) {
        this.funnelNote.setVisible(true);
    }

    private void checkGenerateOK() {
        int temp;
        boolean generateOK = true;
        this.statusPanel.setBackground(this.normal);
        this.status.setText("");
        String statusText = "";
        try {
            temp = Integer.parseInt(this.inTopRadius.getText());
            if (temp <= 1) {
                throw new Exception("topRadius must be positive");
            }
            if (temp < this.bottomRadius) {
                throw new Exception("topRadius must be greater than or equal to bottomRadius");
            }
            this.topRadius = temp;
            this.topRadiusPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.topRadiusPanel.setBackground(Color.red);
        }
        try {
            temp = Integer.parseInt(this.inBottomRadius.getText());
            if (temp < 0) {
                throw new Exception("topRadius cannot be negative");
            }
            if (temp > this.topRadius) {
                throw new Exception("topRadius must be less than or equal to bottomRadius");
            }
            this.bottomRadius = temp;
            this.bottomRadiusPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.bottomRadiusPanel.setBackground(Color.red);
        }
        try {
            int temp2 = Integer.parseInt(this.inHeight.getText());
            this.heightPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.heightPanel.setBackground(Color.red);
        }
        try {
            int temp3 = Integer.parseInt(this.inSlices.getText());
            if (temp3 < 1) {
                throw new Exception("Min slices is 1");
            }
            this.slicesPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.slicesPanel.setBackground(Color.red);
        }
        try {
            int temp4 = Integer.parseInt(this.inCrossSection.getText());
            if (temp4 <= 0) {
                throw new Exception("inCrossSection must be positive");
            }
            this.crossSectionPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            this.statusPanel.setBackground(Color.yellow);
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.crossSectionPanel.setBackground(Color.red);
        }
        try {
            double temp5 = Double.parseDouble(this.inOffsetAngle.getText());
            if (temp5 < 0.0) {
                throw new Exception("Please enter a positive number");
            }
            this.offsetAnglePanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for the offsetAngle\n" : statusText + ex.getMessage() + "\n";
            this.offsetAnglePanel.setBackground(Color.red);
        }
        if (generateOK) {
            this.generate.setEnabled(true);
        } else {
            this.generate.setEnabled(false);
            this.statusPanel.setBackground(Color.yellow);
            this.status.setText(statusText);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FunnelGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FunnelGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FunnelGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FunnelGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new FunnelGeneratorGUI(new Config()).setVisible(true);
            }
        });
    }
}

