/*
 * Decompiled with CFR 0.152.
 */
package com.nerius.math.geom;

public final class Point3D {
    public final double x;
    public final double y;
    public final double z;

    public Point3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Point3D crossProduct(Point3D pt3D) {
        return new Point3D(this.y * pt3D.z - this.z * pt3D.y, this.z * pt3D.x - this.x * pt3D.z, this.x * pt3D.y - this.y * pt3D.x);
    }

    public double distance(Point3D pt3D) {
        return Math.sqrt(this.square(this.x - pt3D.x) + this.square(this.y - pt3D.y) + this.square(this.z - pt3D.z));
    }

    public double distanceFromOrigin() {
        return this.distance(new Point3D(0.0, 0.0, 0.0));
    }

    public Point3D subtract(Point3D pt3D) {
        return new Point3D(this.x - pt3D.x, this.y - pt3D.y, this.z - pt3D.z);
    }

    private double square(double f) {
        return f * f;
    }
}

