/*
 * Decompiled with CFR 0.152.
 */
package generators;

import com.nerius.math.geom.Point3D;
import com.nerius.math.xform.AxisRotation3D;
import generators.GenerationUtils;

public final class BowlGenerator
extends GenerationUtils {
    public static void main(String[] args) {
        Thread.currentThread().setPriority(1);
        int circumferenceRadius = Integer.parseInt(args[0]);
        int slopeRadius = Integer.parseInt(args[1]);
        int slicesCircumference = Integer.parseInt(args[2]);
        int slicesSlope = Integer.parseInt(args[3]);
        int crossSection = Integer.parseInt(args[4]);
        boolean offsetTopInsteadOfBottom = Boolean.valueOf(args[5]);
        boolean overlappingBrushes = Boolean.valueOf(args[6]);
        int extrudeTopNSlices = Integer.parseInt(args[7]);
        double extrudeRadiusFactor = Double.parseDouble(args[8]);
        boolean adjustForOverlappingPipeCuts = Boolean.valueOf(args[9]);
        boolean adjustForOverlappingBowlCuts = Boolean.valueOf(args[10]);
        boolean invertSlopeVertices = Boolean.valueOf(args[11]);
        boolean generateOnlySeam = Boolean.valueOf(args[12]);
        boolean adjustSeamForJoining = Boolean.valueOf(args[13]);
        try {
            int j;
            int i;
            int i2;
            int adjustMask = 0;
            if (adjustForOverlappingBowlCuts) {
                adjustMask |= 2;
            }
            if (adjustForOverlappingPipeCuts) {
                adjustMask |= 1;
            }
            Point3D[] curve = BowlGenerator.generatePipeCurve(slopeRadius, slicesSlope, extrudeTopNSlices, extrudeRadiusFactor, adjustMask);
            if (invertSlopeVertices) {
                Point3D[] newCurve = new Point3D[curve.length];
                for (i2 = 0; i2 < curve.length; ++i2) {
                    newCurve[curve.length - i2 - 1] = new Point3D(-curve[i2].z, curve[i2].y, -curve[i2].x);
                }
                curve = newCurve;
            }
            for (int i3 = 0; i3 < curve.length; ++i3) {
                curve[i3] = new Point3D(curve[i3].x + (double)(circumferenceRadius - slopeRadius), curve[i3].y, curve[i3].z);
            }
            Point3D[][] mesh = new Point3D[slicesCircumference + 1][slicesSlope + 1];
            for (i2 = 0; i2 <= slicesSlope; ++i2) {
                mesh[0][i2] = curve[i2];
            }
            AxisRotation3D rot = new AxisRotation3D(4, Math.PI / (double)(4 * slicesCircumference));
            for (i = 0; i <= slicesSlope; ++i) {
                if (!offsetTopInsteadOfBottom && i % 2 == 1) {
                    mesh[0][i] = rot.transform(mesh[0][i]);
                }
                if (!offsetTopInsteadOfBottom || i % 2 != 0) continue;
                mesh[0][i] = rot.transform(mesh[0][i]);
            }
            for (i = 1; i <= slicesCircumference; ++i) {
                rot = new AxisRotation3D(4, Math.PI * (double)i / (double)(2 * slicesCircumference));
                for (j = 0; j <= slicesSlope; ++j) {
                    mesh[i][j] = rot.transform(mesh[0][j]);
                }
            }
            if (adjustSeamForJoining) {
                for (i = 0; i < curve.length; ++i) {
                    if ((offsetTopInsteadOfBottom || i % 2 != 1) && (!offsetTopInsteadOfBottom || i % 2 != 0)) continue;
                    mesh[slicesCircumference][i] = new Point3D(0.0, curve[i].x, curve[i].z);
                }
            }
            BowlGenerator.startMap();
            for (i = 0; i < slicesCircumference * 2; ++i) {
                if (generateOnlySeam && i != slicesCircumference * 2 - 1) continue;
                for (j = 0; j < slicesSlope; ++j) {
                    Point3D pt3;
                    Point3D pt2;
                    Point3D pt1;
                    if (j == slicesSlope - 1 && circumferenceRadius == slopeRadius && (!offsetTopInsteadOfBottom && slicesSlope % 2 == i % 2 || offsetTopInsteadOfBottom && slicesSlope % 2 != i % 2)) continue;
                    if (i % 2 == 0) {
                        if (!offsetTopInsteadOfBottom && j % 2 == 0 || offsetTopInsteadOfBottom && j % 2 == 1) {
                            pt1 = mesh[i / 2][j];
                            pt2 = mesh[i / 2][j + 1];
                            pt3 = mesh[i / 2 + 1][j];
                        } else {
                            pt1 = mesh[i / 2][j];
                            pt2 = mesh[i / 2][j + 1];
                            pt3 = mesh[i / 2 + 1][j + 1];
                        }
                    } else if (!offsetTopInsteadOfBottom && j % 2 == 0 || offsetTopInsteadOfBottom && j % 2 == 1) {
                        pt1 = mesh[i / 2 + 1][j];
                        pt2 = mesh[i / 2][j + 1];
                        pt3 = mesh[i / 2 + 1][j + 1];
                    } else {
                        pt1 = mesh[i / 2][j];
                        pt2 = mesh[i / 2 + 1][j + 1];
                        pt3 = mesh[i / 2 + 1][j];
                    }
                    int extendXY = circumferenceRadius - slopeRadius + crossSection;
                    BowlGenerator.writeBrushExtendWrapper(extendXY, -crossSection, pt1, pt2, pt3, i >= slicesCircumference, j >= (slicesSlope + 1) / 2, overlappingBrushes);
                    if (overlappingBrushes) continue;
                    if (i == slicesCircumference && j < (slicesSlope + 1) / 2) {
                        BowlGenerator.writeBrushExtendY(extendXY, pt1, new Point3D(extendXY, pt1.y, pt1.z), new Point3D(extendXY, pt2.y, pt2.z), pt2);
                        if (j == (slicesSlope + 1) / 2 - 1) {
                            BowlGenerator.writeBrushExtendZ(-crossSection, pt2, new Point3D(pt2.x, extendXY, pt2.z), new Point3D(extendXY, extendXY, pt2.z), new Point3D(extendXY, pt2.y, pt2.z));
                        }
                    }
                    if (j != (slicesSlope + 1) / 2 - 1 || (offsetTopInsteadOfBottom || i % 2 == j % 2) && (!offsetTopInsteadOfBottom || i % 2 != j % 2)) continue;
                    if (i < slicesCircumference) {
                        BowlGenerator.writeBrushExtendX(extendXY, pt2, new Point3D(pt2.x, pt2.y, -crossSection), new Point3D(pt3.x, pt3.y, -crossSection), pt3);
                        continue;
                    }
                    BowlGenerator.writeBrushExtendY(extendXY, pt2, new Point3D(pt2.x, pt2.y, -crossSection), new Point3D(pt3.x, pt3.y, -crossSection), pt3);
                }
            }
            BowlGenerator.endMap();
        }
        catch (Exception ex) {
            System.out.print(ex.getMessage());
        }
    }

    private static void writeBrushExtendWrapper(int extendXY, int extendZ, Point3D pt1, Point3D pt2, Point3D pt3, boolean pastHalfwayCircum, boolean pastHalfwaySlope, boolean overlappingBrushes) {
        if (!pastHalfwaySlope) {
            if (!pastHalfwayCircum) {
                BowlGenerator.writeBrushExtendX(extendXY, pt1, pt2, pt3, overlappingBrushes);
            } else {
                BowlGenerator.writeBrushExtendY(extendXY, pt1, pt2, pt3, overlappingBrushes);
            }
        } else {
            BowlGenerator.writeBrushExtendZ(extendZ, pt1, pt2, pt3, overlappingBrushes);
        }
    }
}

