/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import main.AboutGUI;
import main.BowlGeneratorGUI;
import main.Config;
import main.CorkscrewGeneratorGUI;
import main.CylinderGeneratorGUI;
import main.DiscGeneratorGUI;
import main.FunnelGeneratorGUI;
import main.GearGeneratorGUI;
import main.OffsetCylinderGeneratorGUI;
import main.OffsetPipeGeneratorGUI;
import main.PipeGeneratorGUI;
import main.SineWaveGeneratorGUI;
import main.VolcanoGeneratorGUI;

public class SurfaceGenerator
extends JFrame {
    private final Dimension smallButton = new Dimension(174, 144);
    private final Dimension smallPanel = new Dimension(820, 490);
    private final Dimension largeButton = new Dimension(255, 209);
    private final Dimension largePanel = new Dimension(1074, 705);
    private Dimension frameSize;
    private int frameWidth;
    private int frameHeight;
    private CylinderGeneratorGUI cylinderGenerator;
    private PipeGeneratorGUI pipeGenerator;
    private DiscGeneratorGUI discGenerator;
    private BowlGeneratorGUI bowlGenerator;
    private CorkscrewGeneratorGUI corkscrewGenerator;
    private FunnelGeneratorGUI funnelGenerator;
    private OffsetCylinderGeneratorGUI offsetCylinderGenerator;
    private OffsetPipeGeneratorGUI offsetPipeGenerator;
    private GearGeneratorGUI gearGenerator;
    private SineWaveGeneratorGUI sineWaveGenerator;
    private VolcanoGeneratorGUI volcanoGenerator;
    private AboutGUI aboutPage;
    Config configuration = new Config();
    int screenWidth = this.configuration.getScreenWidth();
    int screenHeight = this.configuration.getScreenHeight();
    private JMenu View;
    private JMenuItem about;
    private JMenu aboutMenu;
    private Box.Filler filler;
    private JMenuBar menu;
    private JMenuItem opLargeIcons;
    private JMenuItem opSmallIcons;
    private JButton selectBowlGenerator;
    private JButton selectCorkscrewGenerator;
    private JButton selectCylinderGenerator;
    private JButton selectDiscGenerator;
    private JButton selectFunnelGenerator;
    private JButton selectGearGenerator;
    private JButton selectOffsetCylinderGenerator;
    private JButton selectOffsetPipeGenerator;
    private JButton selectPipeGenerator;
    private JButton selectSineWaveGenerator;
    private JButton selectVolcanoGenerator;
    private JPanel selectionPanel;
    private ButtonGroup view;

    public SurfaceGenerator() {
        this.initComponents();
        this.frameSize = this.getSize();
        this.frameWidth = this.frameSize.width;
        this.frameHeight = this.frameSize.height;
        if (this.frameWidth > this.screenWidth || this.frameHeight > this.screenHeight) {
            this.setSmallSize();
        }
    }

    private void initComponents() {
        this.view = new ButtonGroup();
        this.selectionPanel = new JPanel();
        this.selectCylinderGenerator = new JButton();
        this.selectDiscGenerator = new JButton();
        this.selectPipeGenerator = new JButton();
        this.selectBowlGenerator = new JButton();
        this.selectCorkscrewGenerator = new JButton();
        this.selectFunnelGenerator = new JButton();
        this.selectOffsetCylinderGenerator = new JButton();
        this.selectOffsetPipeGenerator = new JButton();
        this.selectGearGenerator = new JButton();
        this.selectSineWaveGenerator = new JButton();
        this.selectVolcanoGenerator = new JButton();
        this.filler = new Box.Filler(new Dimension(255, 209), new Dimension(255, 209), new Dimension(255, 209));
        this.menu = new JMenuBar();
        this.aboutMenu = new JMenu();
        this.about = new JMenuItem();
        this.View = new JMenu();
        this.opSmallIcons = new JMenuItem();
        this.opLargeIcons = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Surface Generator");
        this.setLocationByPlatform(true);
        this.selectionPanel.setMinimumSize(new Dimension(1092, 705));
        this.selectionPanel.setPreferredSize(new Dimension(1092, 705));
        this.selectionPanel.setLayout(new GridLayout(3, 4, 18, 18));
        this.selectCylinderGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/cylinder.png")));
        this.selectCylinderGenerator.setText("Generate Cylinder");
        this.selectCylinderGenerator.setToolTipText("Generates a quarter cylinder as a .map file to be opened in GtkRadiant.");
        this.selectCylinderGenerator.setHorizontalTextPosition(0);
        this.selectCylinderGenerator.setVerticalTextPosition(3);
        this.selectCylinderGenerator.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SurfaceGenerator.this.selectCylinderGeneratorMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SurfaceGenerator.this.selectCylinderGeneratorMouseExited(evt);
            }
        });
        this.selectCylinderGenerator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SurfaceGenerator.this.selectCylinderGeneratorActionPerformed(evt);
            }
        });
        this.selectionPanel.add(this.selectCylinderGenerator);
        this.selectDiscGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/disc.png")));
        this.selectDiscGenerator.setText("Generate Disc");
        this.selectDiscGenerator.setToolTipText("Generates the top half of a disc as a .map file to be opened in GtkRadiant.");
        this.selectDiscGenerator.setHorizontalTextPosition(0);
        this.selectDiscGenerator.setVerticalTextPosition(3);
        this.selectDiscGenerator.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SurfaceGenerator.this.selectDiscGeneratorMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SurfaceGenerator.this.selectDiscGeneratorMouseExited(evt);
            }
        });
        this.selectDiscGenerator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SurfaceGenerator.this.selectDiscGeneratorActionPerformed(evt);
            }
        });
        this.selectionPanel.add(this.selectDiscGenerator);
        this.selectPipeGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/quarterPipeIcon.png")));
        this.selectPipeGenerator.setText("Generate Pipe");
        this.selectPipeGenerator.setToolTipText("Generates a quarter pipe ramp as a .map file to be opened in GtkRadiant.");
        this.selectPipeGenerator.setHorizontalTextPosition(0);
        this.selectPipeGenerator.setVerticalTextPosition(3);
        this.selectPipeGenerator.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SurfaceGenerator.this.selectPipeGeneratorMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SurfaceGenerator.this.selectPipeGeneratorMouseExited(evt);
            }
        });
        this.selectPipeGenerator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SurfaceGenerator.this.selectPipeGeneratorActionPerformed(evt);
            }
        });
        this.selectionPanel.add(this.selectPipeGenerator);
        this.selectBowlGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/bowl.png")));
        this.selectBowlGenerator.setText("Generate Bowl");
        this.selectBowlGenerator.setToolTipText("Generates the rim of a quarter bowl as a .map file to be opened in GtkRadiant.");
        this.selectBowlGenerator.setHorizontalTextPosition(0);
        this.selectBowlGenerator.setVerticalTextPosition(3);
        this.selectBowlGenerator.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SurfaceGenerator.this.selectBowlGeneratorMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SurfaceGenerator.this.selectBowlGeneratorMouseExited(evt);
            }
        });
        this.selectBowlGenerator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SurfaceGenerator.this.selectBowlGeneratorActionPerformed(evt);
            }
        });
        this.selectionPanel.add(this.selectBowlGenerator);
        this.selectCorkscrewGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/corkscrew.png")));
        this.selectCorkscrewGenerator.setText("Generate Corkscrew");
        this.selectCorkscrewGenerator.setToolTipText("Generates a quarter of a corkscrew as a .map file to be opened in GtkRadiant.");
        this.selectCorkscrewGenerator.setHorizontalTextPosition(0);
        this.selectCorkscrewGenerator.setVerticalTextPosition(3);
        this.selectCorkscrewGenerator.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SurfaceGenerator.this.selectCorkscrewGeneratorMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SurfaceGenerator.this.selectCorkscrewGeneratorMouseExited(evt);
            }
        });
        this.selectCorkscrewGenerator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SurfaceGenerator.this.selectCorkscrewGeneratorActionPerformed(evt);
            }
        });
        this.selectionPanel.add(this.selectCorkscrewGenerator);
        this.selectFunnelGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/funnel.png")));
        this.selectFunnelGenerator.setText("Generate Funnel");
        this.selectFunnelGenerator.setToolTipText("Generates a quarter of a funnel as a .map file to be opened in GtkRadiant.");
        this.selectFunnelGenerator.setFocusCycleRoot(true);
        this.selectFunnelGenerator.setHorizontalTextPosition(0);
        this.selectFunnelGenerator.setMaximumSize(new Dimension(255, 209));
        this.selectFunnelGenerator.setMinimumSize(new Dimension(255, 209));
        this.selectFunnelGenerator.setVerticalTextPosition(3);
        this.selectFunnelGenerator.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SurfaceGenerator.this.selectFunnelGeneratorMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SurfaceGenerator.this.selectFunnelGeneratorMouseExited(evt);
            }
        });
        this.selectFunnelGenerator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SurfaceGenerator.this.selectFunnelGeneratorActionPerformed(evt);
            }
        });
        this.selectionPanel.add(this.selectFunnelGenerator);
        this.selectOffsetCylinderGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/offsetCylinder.png")));
        this.selectOffsetCylinderGenerator.setText("Generate Offset Cylinder");
        this.selectOffsetCylinderGenerator.setToolTipText("The vertices are rotated counter-clockwise by a half of a slice.");
        this.selectOffsetCylinderGenerator.setHorizontalTextPosition(0);
        this.selectOffsetCylinderGenerator.setVerticalTextPosition(3);
        this.selectOffsetCylinderGenerator.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SurfaceGenerator.this.selectOffsetCylinderGeneratorMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SurfaceGenerator.this.selectOffsetCylinderGeneratorMouseExited(evt);
            }
        });
        this.selectOffsetCylinderGenerator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SurfaceGenerator.this.selectOffsetCylinderGeneratorActionPerformed(evt);
            }
        });
        this.selectionPanel.add(this.selectOffsetCylinderGenerator);
        this.selectOffsetPipeGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/offset-pipe.png")));
        this.selectOffsetPipeGenerator.setText("Generate Offset Pipe");
        this.selectOffsetPipeGenerator.setToolTipText("The vertices for the curve are rotated downwards by half of a slice.");
        this.selectOffsetPipeGenerator.setHorizontalTextPosition(0);
        this.selectOffsetPipeGenerator.setVerticalTextPosition(3);
        this.selectOffsetPipeGenerator.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SurfaceGenerator.this.selectOffsetPipeGeneratorMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SurfaceGenerator.this.selectOffsetPipeGeneratorMouseExited(evt);
            }
        });
        this.selectOffsetPipeGenerator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SurfaceGenerator.this.selectOffsetPipeGeneratorActionPerformed(evt);
            }
        });
        this.selectionPanel.add(this.selectOffsetPipeGenerator);
        this.selectGearGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/gear.png")));
        this.selectGearGenerator.setText("Generate Gear");
        this.selectGearGenerator.setToolTipText("Generates a gear as a .map file to be opened in GtkRadiant.");
        this.selectGearGenerator.setHorizontalTextPosition(0);
        this.selectGearGenerator.setMaximumSize(new Dimension(255, 209));
        this.selectGearGenerator.setMinimumSize(new Dimension(255, 209));
        this.selectGearGenerator.setPreferredSize(new Dimension(255, 209));
        this.selectGearGenerator.setVerticalTextPosition(3);
        this.selectGearGenerator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SurfaceGenerator.this.selectGearGeneratorActionPerformed(evt);
            }
        });
        this.selectionPanel.add(this.selectGearGenerator);
        this.selectSineWaveGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/sinewave.png")));
        this.selectSineWaveGenerator.setText("Generate Sine Wave");
        this.selectSineWaveGenerator.setToolTipText("This is, at the moment, undocumented and experimental.");
        this.selectSineWaveGenerator.setHorizontalTextPosition(0);
        this.selectSineWaveGenerator.setMaximumSize(new Dimension(255, 209));
        this.selectSineWaveGenerator.setMinimumSize(new Dimension(255, 209));
        this.selectSineWaveGenerator.setPreferredSize(new Dimension(255, 209));
        this.selectSineWaveGenerator.setVerticalTextPosition(3);
        this.selectSineWaveGenerator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SurfaceGenerator.this.selectSineWaveGeneratorActionPerformed(evt);
            }
        });
        this.selectionPanel.add(this.selectSineWaveGenerator);
        this.selectVolcanoGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/volcano.png")));
        this.selectVolcanoGenerator.setText("Generate Volcano");
        this.selectVolcanoGenerator.setToolTipText("Generates a quarter of a volcano shape, which is actually the inner rim of the inside of a donut. The .map file that is generated is to be opened in GtkRadiant.");
        this.selectVolcanoGenerator.setHorizontalTextPosition(0);
        this.selectVolcanoGenerator.setMaximumSize(new Dimension(255, 209));
        this.selectVolcanoGenerator.setMinimumSize(new Dimension(255, 209));
        this.selectVolcanoGenerator.setPreferredSize(new Dimension(255, 209));
        this.selectVolcanoGenerator.setVerticalTextPosition(3);
        this.selectVolcanoGenerator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SurfaceGenerator.this.selectVolcanoGeneratorActionPerformed(evt);
            }
        });
        this.selectionPanel.add(this.selectVolcanoGenerator);
        this.filler.setFocusable(false);
        this.selectionPanel.add(this.filler);
        this.aboutMenu.setText("About");
        this.about.setText("About This Program");
        this.about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SurfaceGenerator.this.aboutActionPerformed(evt);
            }
        });
        this.aboutMenu.add(this.about);
        this.menu.add(this.aboutMenu);
        this.View.setText("View");
        this.View.setToolTipText("Change the display size of the main window");
        this.view.add(this.View);
        this.opSmallIcons.setText("small Icons");
        this.opSmallIcons.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SurfaceGenerator.this.opSmallIconsActionPerformed(evt);
            }
        });
        this.View.add(this.opSmallIcons);
        this.opLargeIcons.setText("large Icons");
        this.opLargeIcons.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SurfaceGenerator.this.opLargeIconsActionPerformed(evt);
            }
        });
        this.View.add(this.opLargeIcons);
        this.menu.add(this.View);
        this.setJMenuBar(this.menu);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.selectionPanel, -1, -1, Short.MAX_VALUE).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.selectionPanel, -1, -1, Short.MAX_VALUE).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void selectCylinderGeneratorActionPerformed(ActionEvent evt) {
        if (this.cylinderGenerator == null) {
            this.cylinderGenerator = new CylinderGeneratorGUI(this.configuration);
        }
        this.cylinderGenerator.setVisible(true);
    }

    private void aboutActionPerformed(ActionEvent evt) {
        if (this.aboutPage == null) {
            this.aboutPage = new AboutGUI();
        }
        this.aboutPage.setVisible(true);
    }

    private void selectDiscGeneratorActionPerformed(ActionEvent evt) {
        if (this.discGenerator == null) {
            this.discGenerator = new DiscGeneratorGUI(this.configuration);
        }
        this.discGenerator.setVisible(true);
    }

    private void selectDiscGeneratorMouseEntered(MouseEvent evt) {
    }

    private void selectDiscGeneratorMouseExited(MouseEvent evt) {
    }

    private void selectCylinderGeneratorMouseEntered(MouseEvent evt) {
    }

    private void selectCylinderGeneratorMouseExited(MouseEvent evt) {
    }

    private void selectPipeGeneratorMouseEntered(MouseEvent evt) {
    }

    private void selectPipeGeneratorMouseExited(MouseEvent evt) {
    }

    private void selectPipeGeneratorActionPerformed(ActionEvent evt) {
        if (this.pipeGenerator == null) {
            this.pipeGenerator = new PipeGeneratorGUI(this.configuration);
        }
        this.pipeGenerator.setVisible(true);
    }

    private void selectBowlGeneratorMouseEntered(MouseEvent evt) {
    }

    private void selectBowlGeneratorMouseExited(MouseEvent evt) {
    }

    private void selectBowlGeneratorActionPerformed(ActionEvent evt) {
        if (this.bowlGenerator == null) {
            this.bowlGenerator = new BowlGeneratorGUI(this.configuration);
        }
        this.bowlGenerator.setVisible(true);
    }

    private void selectCorkscrewGeneratorMouseEntered(MouseEvent evt) {
    }

    private void selectCorkscrewGeneratorMouseExited(MouseEvent evt) {
    }

    private void selectCorkscrewGeneratorActionPerformed(ActionEvent evt) {
        if (this.corkscrewGenerator == null) {
            this.corkscrewGenerator = new CorkscrewGeneratorGUI(this.configuration);
        }
        this.corkscrewGenerator.setVisible(true);
    }

    private void selectFunnelGeneratorMouseEntered(MouseEvent evt) {
    }

    private void selectFunnelGeneratorMouseExited(MouseEvent evt) {
    }

    private void selectFunnelGeneratorActionPerformed(ActionEvent evt) {
        if (this.funnelGenerator == null) {
            this.funnelGenerator = new FunnelGeneratorGUI(this.configuration);
        }
        this.funnelGenerator.setVisible(true);
    }

    private void selectOffsetCylinderGeneratorMouseEntered(MouseEvent evt) {
    }

    private void selectOffsetCylinderGeneratorMouseExited(MouseEvent evt) {
    }

    private void selectOffsetCylinderGeneratorActionPerformed(ActionEvent evt) {
        if (this.offsetCylinderGenerator == null) {
            this.offsetCylinderGenerator = new OffsetCylinderGeneratorGUI(this.configuration);
        }
        this.offsetCylinderGenerator.setVisible(true);
    }

    private void selectOffsetPipeGeneratorMouseEntered(MouseEvent evt) {
    }

    private void selectOffsetPipeGeneratorMouseExited(MouseEvent evt) {
    }

    private void selectOffsetPipeGeneratorActionPerformed(ActionEvent evt) {
        if (this.offsetPipeGenerator == null) {
            this.offsetPipeGenerator = new OffsetPipeGeneratorGUI(this.configuration);
        }
        this.offsetPipeGenerator.setVisible(true);
    }

    private void selectGearGeneratorActionPerformed(ActionEvent evt) {
        if (this.gearGenerator == null) {
            this.gearGenerator = new GearGeneratorGUI(this.configuration);
        }
        this.gearGenerator.setVisible(true);
    }

    private void selectSineWaveGeneratorActionPerformed(ActionEvent evt) {
        if (this.sineWaveGenerator == null) {
            this.sineWaveGenerator = new SineWaveGeneratorGUI(this.configuration);
        }
        this.sineWaveGenerator.setVisible(true);
    }

    private void selectVolcanoGeneratorActionPerformed(ActionEvent evt) {
        if (this.volcanoGenerator == null) {
            this.volcanoGenerator = new VolcanoGeneratorGUI(this.configuration);
        }
        this.volcanoGenerator.setVisible(true);
    }

    private void opSmallIconsActionPerformed(ActionEvent evt) {
        this.setSmallSize();
    }

    private void opLargeIconsActionPerformed(ActionEvent evt) {
        this.setLargeSize();
    }

    private void setSmallSize() {
        this.selectDiscGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/disc_sm.png")));
        this.selectDiscGenerator.setMaximumSize(this.smallButton);
        this.selectDiscGenerator.setMinimumSize(this.smallButton);
        this.selectDiscGenerator.setPreferredSize(this.smallButton);
        this.selectPipeGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/quarterPipeIcon_sm.png")));
        this.selectPipeGenerator.setMaximumSize(this.smallButton);
        this.selectPipeGenerator.setMinimumSize(this.smallButton);
        this.selectPipeGenerator.setPreferredSize(this.smallButton);
        this.selectCylinderGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/cylinder_sm.png")));
        this.selectCylinderGenerator.setMaximumSize(this.smallButton);
        this.selectCylinderGenerator.setMinimumSize(this.smallButton);
        this.selectCylinderGenerator.setPreferredSize(this.smallButton);
        this.selectFunnelGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/funnel_sm.png")));
        this.selectFunnelGenerator.setMaximumSize(this.smallButton);
        this.selectFunnelGenerator.setMinimumSize(this.smallButton);
        this.selectFunnelGenerator.setPreferredSize(this.smallButton);
        this.selectCorkscrewGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/corkscrew_sm.png")));
        this.selectCorkscrewGenerator.setMaximumSize(this.smallButton);
        this.selectCorkscrewGenerator.setMinimumSize(this.smallButton);
        this.selectCorkscrewGenerator.setPreferredSize(this.smallButton);
        this.selectBowlGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/bowl_sm.png")));
        this.selectBowlGenerator.setMaximumSize(this.smallButton);
        this.selectBowlGenerator.setMinimumSize(this.smallButton);
        this.selectBowlGenerator.setPreferredSize(this.smallButton);
        this.selectOffsetPipeGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/offset-pipe_sm.png")));
        this.selectOffsetPipeGenerator.setMaximumSize(this.smallButton);
        this.selectOffsetPipeGenerator.setMinimumSize(this.smallButton);
        this.selectOffsetPipeGenerator.setPreferredSize(this.smallButton);
        this.selectOffsetCylinderGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/offsetCylinder_sm.png")));
        this.selectOffsetCylinderGenerator.setMaximumSize(this.smallButton);
        this.selectOffsetCylinderGenerator.setMinimumSize(this.smallButton);
        this.selectOffsetCylinderGenerator.setPreferredSize(this.smallButton);
        this.selectGearGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/gear_sm.png")));
        this.selectGearGenerator.setMaximumSize(this.smallButton);
        this.selectGearGenerator.setMinimumSize(this.smallButton);
        this.selectGearGenerator.setPreferredSize(this.smallButton);
        this.selectSineWaveGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/sinewave_sm.png")));
        this.selectSineWaveGenerator.setMaximumSize(this.smallButton);
        this.selectSineWaveGenerator.setMinimumSize(this.smallButton);
        this.selectSineWaveGenerator.setPreferredSize(this.smallButton);
        this.selectVolcanoGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/volcano_sm.png")));
        this.selectVolcanoGenerator.setMaximumSize(this.smallButton);
        this.selectVolcanoGenerator.setMinimumSize(this.smallButton);
        this.selectVolcanoGenerator.setPreferredSize(this.smallButton);
        this.filler.setMaximumSize(this.smallButton);
        this.filler.setMinimumSize(this.smallButton);
        this.filler.setPreferredSize(this.smallButton);
        this.selectionPanel.setMaximumSize(this.smallPanel);
        this.selectionPanel.setMinimumSize(this.smallPanel);
        this.selectionPanel.setPreferredSize(this.smallPanel);
        this.pack();
    }

    private void setLargeSize() {
        this.selectDiscGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/disc.png")));
        this.selectDiscGenerator.setMaximumSize(this.largeButton);
        this.selectDiscGenerator.setMinimumSize(this.largeButton);
        this.selectDiscGenerator.setPreferredSize(this.largeButton);
        this.selectPipeGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/quarterPipeIcon.png")));
        this.selectPipeGenerator.setMaximumSize(this.largeButton);
        this.selectPipeGenerator.setMinimumSize(this.largeButton);
        this.selectPipeGenerator.setPreferredSize(this.largeButton);
        this.selectCylinderGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/cylinder.png")));
        this.selectCylinderGenerator.setMaximumSize(this.largeButton);
        this.selectCylinderGenerator.setMinimumSize(this.largeButton);
        this.selectCylinderGenerator.setPreferredSize(this.largeButton);
        this.selectFunnelGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/funnel.png")));
        this.selectFunnelGenerator.setMaximumSize(this.largeButton);
        this.selectFunnelGenerator.setMinimumSize(this.largeButton);
        this.selectFunnelGenerator.setPreferredSize(this.largeButton);
        this.selectCorkscrewGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/corkscrew.png")));
        this.selectCorkscrewGenerator.setMaximumSize(this.largeButton);
        this.selectCorkscrewGenerator.setMinimumSize(this.largeButton);
        this.selectCorkscrewGenerator.setPreferredSize(this.largeButton);
        this.selectBowlGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/bowl.png")));
        this.selectBowlGenerator.setMaximumSize(this.largeButton);
        this.selectBowlGenerator.setMinimumSize(this.largeButton);
        this.selectBowlGenerator.setPreferredSize(this.largeButton);
        this.selectOffsetPipeGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/offset-pipe.png")));
        this.selectOffsetPipeGenerator.setMaximumSize(this.largeButton);
        this.selectOffsetPipeGenerator.setMinimumSize(this.largeButton);
        this.selectOffsetPipeGenerator.setPreferredSize(this.largeButton);
        this.selectOffsetCylinderGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/offsetCylinder.png")));
        this.selectOffsetCylinderGenerator.setMaximumSize(this.largeButton);
        this.selectOffsetCylinderGenerator.setMinimumSize(this.largeButton);
        this.selectOffsetCylinderGenerator.setPreferredSize(this.largeButton);
        this.selectGearGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/gear.png")));
        this.selectGearGenerator.setMaximumSize(this.largeButton);
        this.selectGearGenerator.setMinimumSize(this.largeButton);
        this.selectGearGenerator.setPreferredSize(this.largeButton);
        this.selectSineWaveGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/sinewave.png")));
        this.selectSineWaveGenerator.setMaximumSize(this.largeButton);
        this.selectSineWaveGenerator.setMinimumSize(this.largeButton);
        this.selectSineWaveGenerator.setPreferredSize(this.largeButton);
        this.selectVolcanoGenerator.setIcon(new ImageIcon(this.getClass().getResource("/main/volcano.png")));
        this.selectVolcanoGenerator.setMaximumSize(this.largeButton);
        this.selectVolcanoGenerator.setMinimumSize(this.largeButton);
        this.selectVolcanoGenerator.setPreferredSize(this.largeButton);
        this.filler.setMaximumSize(this.largeButton);
        this.filler.setMinimumSize(this.largeButton);
        this.filler.setPreferredSize(this.largeButton);
        this.selectionPanel.setMaximumSize(this.largePanel);
        this.selectionPanel.setMinimumSize(this.largePanel);
        this.selectionPanel.setPreferredSize(this.largePanel);
        this.pack();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(SurfaceGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(SurfaceGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(SurfaceGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(SurfaceGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SurfaceGenerator system = new SurfaceGenerator();
                system.setVisible(true);
            }
        });
    }
}

