-- hypov8
-- will animate a q3 model into a kingpin usable model
--
-- === instructions ===
-- Using "Quake3 md3 Import". Import lower.md3, upper.md3, head.md3 then shotgun.md3. (Auto attatch tags and load animations)
-- Press "Load Q3 Animation.cfg" and select the file matching the model animations
-- OPTION: "Use Q3 FPS for Death" can be used if the animation is the wrong speed in kingpin
-- Press "convert Q3 model to KP"


utility QuakeMD3_To_Kingpin "Q3 to Kingpin"
(
	local array_frameFileQ3=#() --txt file with 25 leg/body events (structure(start,end)
	
	local array_legs=#()
	local array_body=#()
	local array_head=#()
	local array_wep=#()
	local array_kp_Anims=#()
	
	local end_task = false
 
	-- q3 animation file indexed names
	local BOTH_DEATH1 = 1 as integer 
	local BOTH_DEAD1 = 2 as integer 
	local BOTH_DEATH2 = 3 as integer 
	local BOTH_DEAD2 = 4 as integer 
	local BOTH_DEATH3 = 5 as integer 
	local BOTH_DEAD3 = 6 as integer 
	local TORSO_GESTURE = 7 as integer 
	local TORSO_ATTACK = 8 as integer 
	local TORSO_ATTACK2 = 9 as integer 
	local TORSO_DROP = 10 as integer 
	local TORSO_RAISE = 11 as integer 
	local TORSO_STAND = 12 as integer 
	local TORSO_STAND2 = 13 as integer 
	local LEGS_WALKCR = 14 as integer 
	local LEGS_WALK = 15 as integer 
	local LEGS_RUN = 16 as integer 
	local LEGS_BACK = 17 as integer 
	local LEGS_SWIM = 18 as integer 
	local LEGS_JUMP = 19 as integer 
	local LEGS_LAND = 20 as integer 
	local LEGS_JUMPB = 21 as integer 
	local LEGS_LANDB = 22 as integer 
	local LEGS_IDLE = 23 as integer 
	local LEGS_IDLECR = 24 as integer 
	local LEGS_TURN = 25 as integer 
	
 	-- forward the body parts group for functions
	local  MODEL_LEGS = 1  as integer
	local  MODEL_HEAD = 2  as integer
	local  MODEL_BODY = 3 as integer
	local  MODEL_WEPS = 4 as integer
	
	local	tag_legs_nodeID = undefined
	--local	tag_body_nodeID= undefined
	local	tag_head_nodeID = undefined
	local	tag_wep_nodeID = undefined



	
	local string_Tip_FILE =	"Enable: Death Animations Speeds are calculated\nfrom q3 animation fps\n" + \
							"Disable: will squeeze/stretch animation to fit into kp "
							
	local string_Tip_GO =	"Created new objects with name KP_*\n" + \
							"Will search all non hidden items with names\ntag_* \nL_* \nH_* \nU_* \nw_* "	
							
	local string_Tip_INFO =	"Using 'Quake3 md3 Import' script.\n" + \ 
							"Enable 'Auto attatch' tags and 'load animations'\n" + \		
							"Import lower.md3, upper.md3, head.md3 then shotgun.md3.\n" + \ 
							"\n" + \ 
							"Press 'Load Q3 Animation.cfg' and select the file matching the imported Q3 model\n" + \
							"\n" + \ 		
							"Press 'convert Q3 model to KP'"
		
	local string_Tip_IDLE =	"Enable: use only 1 frame from leg Animations for taunt etc..\n" + \
							"Disable: will use q3's complte leg idle animation "		


	-- UI
	button 		UI_btn_GetFile 			"Load Q3 Animation.cfg " 	align:#left 	height:22 width:136 tooltip:"select file"
	button 		UI_btn_DoConversion 	"Convert Q3 model to KP" 	align:#left 	height:22 width:136 tooltip:string_Tip_GO	
	checkbox 	UI_useFrameRateForDeath "Use Q3 FPS for Death  " 	align:#left 	height:16 width:136 tooltip:string_Tip_FILE	checked:true
	checkbox 	UI_useOneIdleFrame 		"Use No Idle Animation " 	align:#left 	height:16 width:136 tooltip:string_Tip_IDLE checked:false	
	button 		UI_btn_Info 			"Info" 						align:#centre 	height:22 width:136
	
	on UI_btn_Info pressed do
	(
		messageBox string_Tip_INFO title:"Instructions" 
	)
																											
	
	struct frame_num_q3
	(
		start,
		total_fr,
		fps
	)
	
	struct frame_num_KP
	(
		start,
		end,
		head,
		wep,
		legs,
		body
	)
	
	--keyframe tangents
	struct key_tangnt
	(
		outTangentType,
		inTangentType
	)
		
	--set tangent type (start/mid/end frame)	
	fn get_tagent_type_fn key_f q3_current_f q3_total_f =
	(
		--local k --=#(key_tangnt inTangentType:#step outTangentType:#step )
		
		if (q3_total_f == 1) then 	
		(--only 1 keyFrame
			key_f.inTangentType = #step 
			key_f.outTangentType = #step
		)
		else if (q3_current_f == 0) then --first frame
		(
			key_f.inTangentType = #step
			key_f.outTangentType =#linear
		)
		else if (q3_current_f >= (q3_total_f - 1)) then --last frame
		(
			key_f.inTangentType = #linear
			key_f.outTangentType = #step
		)
		else	--any frame between
		(
			key_f.inTangentType = #linear 
			key_f.outTangentType = #linear
		)
		--return q3_current_f
	)
	
	--key frame rotation legs (no parent)
	fn addkeyROT_world_fn targetObj_f sourceObj_f time_kp_f time_q3_f q3_key_f frames_total_q3_f=
	(
		--in coordSys local $tag_torso.rotation.z_rotation
		local k
		k = addNewKey targetObj_f.rotation.x_rotation.controller time_kp_f
		get_tagent_type_fn k q3_key_f frames_total_q3_f 
		k.value = sourceObj_f.rotation.x_rotation.controller.keys[time_q3_f+1].value
		
		k = addNewKey targetObj_f.rotation.y_rotation.controller time_kp_f
		get_tagent_type_fn k q3_key_f frames_total_q3_f 
		k.value = sourceObj_f.rotation.y_rotation.controller.keys[time_q3_f+1].value
		
		k = addNewKey targetObj_f.rotation.z_rotation.controller time_kp_f
		get_tagent_type_fn k q3_key_f frames_total_q3_f 
		k.value = sourceObj_f.rotation.z_rotation.controller.keys[time_q3_f+1].value
	)	
	--key frame XYZ legs (no parent)
	fn addkeyPOS_world_fn targetObj_f sourceObj_f time_kp_f time_q3_f q3_key_f frames_total_q3_f=
	(
		local k
		k = addNewKey targetObj_f.pos.x_position.controller time_kp_f
		get_tagent_type_fn k q3_key_f frames_total_q3_f 
		k.value = at time time_q3_f in coordSys parent sourceObj_f.pos.x
		k = addNewKey targetObj_f.pos.y_position.controller time_kp_f
		get_tagent_type_fn k q3_key_f frames_total_q3_f 
		k.value = at time time_q3_f in coordSys parent sourceObj_f.pos.y									
		k = addNewKey targetObj_f.pos.z_position.controller time_kp_f
		get_tagent_type_fn k q3_key_f frames_total_q3_f 
		k.value = at time time_q3_f in coordSys parent sourceObj_f.pos.z							
	)		

	--key frame rotation
	fn addkeyROT_srcPrnt_fn targetObj_f sourceObj_f time_kp_f time_q3_f q3_key_f frames_total_q3_f=
	(
		local k
		k = addNewKey targetObj_f.rotation.x_rotation.controller time_kp_f
		get_tagent_type_fn k q3_key_f frames_total_q3_f 
		k.value = at time time_q3_f in coordSys sourceObj_f.parent sourceObj_f.rotation.x_rotation
		k = addNewKey targetObj_f.rotation.y_rotation.controller time_kp_f
		get_tagent_type_fn k q3_key_f frames_total_q3_f 
		k.value = at time time_q3_f in coordSys sourceObj_f.parent sourceObj_f.rotation.y_rotation									
		k = addNewKey targetObj_f.rotation.z_rotation.controller time_kp_f
		get_tagent_type_fn k q3_key_f frames_total_q3_f 
		k.value = at time time_q3_f in coordSys sourceObj_f.parent sourceObj_f.rotation.z_rotation								
	)	
	--key frame XYZ	
	fn addkeyPOS_srcPrnt_fn targetObj_f sourceObj_f time_kp_f time_q3_f q3_key_f frames_total_q3_f=
	(
		local k
		k = addNewKey targetObj_f.pos.x_position.controller time_kp_f
		get_tagent_type_fn k q3_key_f frames_total_q3_f 
		k.value = at time time_q3_f in coordSys sourceObj_f.parent sourceObj_f.pos.x
		k = addNewKey targetObj_f.pos.y_position.controller time_kp_f
		get_tagent_type_fn k q3_key_f frames_total_q3_f 
		k.value = at time time_q3_f in coordSys sourceObj_f.parent sourceObj_f.pos.y									
		k = addNewKey targetObj_f.pos.z_position.controller time_kp_f
		get_tagent_type_fn k q3_key_f frames_total_q3_f 
		k.value = at time time_q3_f in coordSys sourceObj_f.parent sourceObj_f.pos.z							
	)			
	
	
	-- arange frames from lowest to higest total frames DEATH1=low DEATH3=high
	fn sortDeathAni_ByFrames_fn =
	(
		local highIndex = 5
		local lowIndex = 1, tmpVal=#(0,0,0,0,0)
		tmpVal[1] = array_frameFileQ3[1].total_fr
		tmpVal[3]= array_frameFileQ3[3].total_fr				
		tmpVal[5] = array_frameFileQ3[5].total_fr	
		
		if tmpVal[1] < tmpVal[3] and tmpVal[1] < tmpVal[5] then	lowIndex = 1
		if tmpVal[3] < tmpVal[5] and tmpVal[3] < tmpVal[1] then	lowIndex = 3
		if tmpVal[5] < tmpVal[1] and tmpVal[5] < tmpVal[3] then	lowIndex = 5
		if lowIndex != 1 then
		(
			swap array_frameFileQ3[1] array_frameFileQ3[lowIndex]
			swap array_frameFileQ3[2] array_frameFileQ3[lowIndex+1]
		)
		
		tmpVal[3] = array_frameFileQ3[3].total_fr
		tmpVal[5] = array_frameFileQ3[5].total_fr	
		
		if tmpVal[3] > tmpVal[5] then highIndex = 3
		if tmpVal[5] > tmpVal[3]  then highIndex = 5
		if highIndex !=5 then	
		(
			swap array_frameFileQ3[3] array_frameFileQ3[5]
			swap array_frameFileQ3[4] array_frameFileQ3[6]
		)
		
	)
						
	
	fn moveModelKeys_fn grouped_md3_f body_part_f=
	(
		slidertime = 0		
		print("----- moving ANIMATION SET keys -----")	
		--progressUpdate(1)
		case body_part_f of
		(
			MODEL_LEGS: progressStart "Converting... (MODEL_LEGS)"
			MODEL_BODY: progressStart "Converting... (MODEL_BODY)"	
			MODEL_HEAD: progressStart "Converting... (MODEL_HEAD)"	
			MODEL_WEPS: progressStart "Converting... (MODEL_WEPS)"					
		)		

		------------------------------------------------------
		-- loop through all grouped model parts
		------------------------------------------------------
		for sourceObj in grouped_md3_f do
		(
			if end_task == false then
			(
				local aniset_kp_count = 0 as integer
				local progress_cnt2 = 0 as integer --reset progress bar for each object
				local obj_isTag = 0 as integer
				local objectsName = sourceObj.name as name --string
				local tagname = substring sourceObj.name 1 4 as name --string
				local masterCtrl
				local progresss_percent
				
				print("------>model= " +objectsName as string  +"  modelPart=" + (body_part_f as string) )
				--print("-------------------------------------------------------")
						
				if (tagname == "tag_" as name) then --tag_ item
				(
					obj_isTag = 1
					
					-- rename new object
					if (body_part_f == MODEL_LEGS) then	(
						tempname = uniqueName ("KP_" + sourceObj.name + "_InLegs")
					)
					else if (body_part_f == MODEL_BODY) then (					
						if (objectsName == "tag_torso" as name) then continue --not needed	
						tempname = uniqueName   ("KP_" + sourceObj.name + "_InBody_") 				
					)
					else if (body_part_f == MODEL_HEAD) then (	
						if (objectsName == "tag_head" as name) then continue --not needed						
						tempname = uniqueName   ("KP_" + sourceObj.name + "_InHead_")
					)	
					else if (body_part_f == MODEL_WEPS) then (	
						if (objectsName == "tag_wep" as name) then continue --not needed	
						if (objectsName == "tag_flash" as name) then continue --not needed					
						tempname = uniqueName   ("KP_" + sourceObj.name + "_Inwep_")						
					)		
					else(
						print("-----------tag error---------------- " )
						continue
					)
					
					targetObj = at time 0 snapshot sourceObj name:tempname	
					convertTo targetObj Editable_Mesh
					targetObj.controller = sourceObj.controller
					InstanceMgr.MakeControllersUnique targetObj targetObj.controller #individual --prompt
					
					deleteKeys targetObj #allKeys
					
					--
					if (body_part_f == MODEL_LEGS) then	
					(
						if (objectsName == "tag_torso" as name) then 
							tag_legs_nodeID = targetObj.inode.handle
					)
					if (body_part_f == MODEL_BODY) then
					(	
						if (objectsName == "tag_head" as name) then	
							tag_head_nodeID = targetObj.inode.handle	
						else if (objectsName == "tag_weapon" as name) then	
							tag_wep_nodeID = targetObj.inode.handle
					)
					

					if (body_part_f == MODEL_BODY) or ( body_part_f == MODEL_HEAD) or  (body_part_f == MODEL_WEPS) then		
					(	
						--print("--------------------tag group parent-------------------")
						local tag_parent_ID = tag_legs_nodeID  as integer
						if (body_part_f == MODEL_HEAD) then 	
							tag_parent_ID  = tag_head_nodeID as integer
						if (body_part_f == MODEL_WEPS) then 	
							tag_parent_ID  = tag_wep_nodeID as integer				
							
						targetObj.parent = undefined
						targetObj.pos = [0,0,0]

						in coordsys world targetObj.rotation = quat 0.0 0.0 0.0 1.0
							
						for parent_obj in objects do
						(
							if parent_obj.isHidden then 
								continue -- node is hidden, skip
							if (parent_obj.inode.handle == tag_parent_ID) then
							(
								print("------>tags_parent= " +parent_obj.name as string)										
								targetObj.parent = parent_obj --tag_body -- todo check wep. head..
								exit
							)
						--print("-----------------------end tag parent------------------")							
						)
					
					)
					--print("-----------------------end tags------------------------")
				)
				else 
				(
					obj_isTag = 0

					tempname = uniqueName ("KP_" + sourceObj.name + "_")
					targetObj = snapshot sourceObj name:tempname
					convertTo targetObj Editable_Mesh
					targetObj.controller = sourceObj.controller
					animateVertex targetObj #all

					InstanceMgr.MakeControllersUnique targetObj targetObj.controller #prompt 
					
					masterCtrl = targetObj[4][1]
					deleteKeys masterCtrl #allKeys --todo does root work?
				)	
				
			
				-- loop through all kp animation sequences
				for aniset_kp in array_kp_Anims do
				(
					local frames_total_kp, frames_total_q3, frame_start_kp, frame_end_kp,  frameID_start_q3		
					local modelIndex_q3 = 1 as integer
					
					case body_part_f of
					(
						MODEL_LEGS: modelIndex_q3 = aniset_kp.legs as integer
						MODEL_BODY: modelIndex_q3 = aniset_kp.body as integer
						MODEL_HEAD: modelIndex_q3 = aniset_kp.head as integer
						MODEL_WEPS: modelIndex_q3 = aniset_kp.wep as integer					
					)					
					
							
					aniset_kp_count += 1
					
					-- ENABLE TO TEST: get specific frames.
					--if (aniset_kp_count != 1 ) and (aniset_kp_count != 2)and (aniset_kp_count != 3)and (aniset_kp_count != 27) then
						--continue
	---------------					
					progresss_percent = 100.0* aniset_kp_count / array_kp_Anims.count
					progress_cnt2 +=1	
					progressUpdate (progresss_percent)
	---------------			

					
					frame_start_kp = aniset_kp.start as integer
					frame_end_kp = aniset_kp.end as integer				
					frames_total_kp = ((aniset_kp.end+1) - aniset_kp.start) as integer

					
					if (body_part_f == MODEL_HEAD) or (body_part_f == MODEL_WEPS) then
					(
						frames_total_q3 = 1 as integer
						frameID_start_q3 = 1 as integer
					)
					else
					(
						if (body_part_f == MODEL_LEGS) then 
							modelIndex_q3 = aniset_kp.legs
						else 
							modelIndex_q3 = aniset_kp.body
					
						frames_total_q3 = array_frameFileQ3[modelIndex_q3].total_fr as integer
						frameID_start_q3 = array_frameFileQ3[modelIndex_q3].start as integer
					)
					
					local frames_fps_multiply_q3 =  1	
					local IsUsingDeath_FPS = false		
					if UI_useFrameRateForDeath.state then	--will scale death animation speeds to match frame rate in q3 file		
					(					
						if aniset_kp_count == 24 or aniset_kp_count == 25 or aniset_kp_count == 26 or aniset_kp_count == 27 then	-- death animations
						(
							--frames_fps_multiply_q3 = ((array_frameFileQ3[modelIndex_q3].fps as float) / 10) as float
							frames_fps_multiply_q3 = (10 / (array_frameFileQ3[modelIndex_q3].fps as float)) as float
							local total_fps_Q3 = ((frames_fps_multiply_q3 as float) * frames_total_q3) as float
							if frames_total_kp >= total_fps_Q3 as float  then
								IsUsingDeath_FPS = true
						)
					)
						
					
					-- get every q3 keyframe. paste to kp frame %
					-- make sure we have a start and end frame (0-1)
					for q3_key = 0 to  frames_total_q3 do -- do first to last frame (can be a single frame)
					(
						local time_kp
						local time_q3					
						
						if (q3_key == 0) then 	--first frame
						(
							time_kp = frame_start_kp  as float
							time_q3 = (frameID_start_q3) as integer
							--print("-- first key Q3-----")
						)
						else	if (q3_key == 1) and (frames_total_q3 == 1) then  --only has 1 frame
						(
							time_kp = frame_end_kp  as float
							time_q3 = (frameID_start_q3) as integer
							--print("-- last key Q3-----")
						)	
						else	if (q3_key == (frames_total_q3 - 1)) and ( IsUsingDeath_FPS == false) then  --total frames(no fps change)
						(
							time_kp = frame_end_kp  as float
							time_q3 = (frameID_start_q3 + (q3_key))  as integer
							--print("-- last key Q3-----")
						)
						else if (q3_key <= (frames_total_q3 - 1)) then
						(	
							local tween_fr =	( (frames_total_kp - 1 as Double) / (frames_total_q3 - 1 as Double) ) as Double --was (frames_total_q3-1)
							if IsUsingDeath_FPS then
								tween_fr = frames_fps_multiply_q3 as Double		
							tween_fr *=	q3_key as Double	
							time_kp = (frame_start_kp + tween_fr)  as float
							time_q3 = (frameID_start_q3 + (q3_key))	 as integer	
						)	-- end q3 frame numbers
						else
						(
							if IsUsingDeath_FPS then	-- death animations, 1 extra last frame
							(	
								time_kp = frame_end_kp  as float
								time_q3 = (frameID_start_q3 + (q3_key - 1))  as integer
							)
							else -- end 1 extra frame. for death animations
								exit
						) --> end q3_keys setup
	
						--start copying animation for each q3 frame
						if ( obj_isTag == 1) then -- is a tag_
						(
							if (body_part_f == MODEL_LEGS) then -- must be TAG_TORSO in legs
							(
								--k = addNewKey targetObj.rotation.controller time_kp
								--k.value = at time time_q3 in coordSys world sourceObj.transform
								
								addkeyROT_world_fn targetObj sourceObj time_kp time_q3 q3_key frames_total_q3 
								addkeyPOS_world_fn targetObj sourceObj time_kp time_q3 q3_key frames_total_q3 
								
								k = addNewKey targetObj.scale.controller time_kp
								get_tagent_type_fn k q3_key frames_total_q3 
								k.value = at time time_q3 in coordSys world sourceObj.scale
							)	
							else if (body_part_f == MODEL_BODY) or( body_part_f == MODEL_HEAD) or (body_part_f == MODEL_WEPS) then	 --all other tags
							(
								-- child tags
								addkeyROT_srcPrnt_fn targetObj sourceObj time_kp time_q3 q3_key frames_total_q3 
								addkeyPOS_srcPrnt_fn targetObj sourceObj time_kp time_q3 q3_key frames_total_q3 								
																	
								k = addNewKey targetObj.scale.controller time_kp
								get_tagent_type_fn k q3_key frames_total_q3 								
								k.value = at time time_q3 in coordSys sourceObj.parent sourceObj.scale								
							) --> END tags in body_group					
						) --> END tag config
						else
						( 	-- vertex animated mesh	objects			
							for i = 1 to targetObj.numVerts do 
							(
								k = addNewKey masterCtrl[i].controller time_kp		
								get_tagent_type_fn k q3_key frames_total_q3 
								k.value = at time time_q3 in coordSys sourceObj getVert sourceObj i -- was sourceObj
								--k.value = at time time_q3 sourceObj.baseobject[#master_point_controller][i].value
							)				
						) --> END vertex animated mesh objects
						
					) --> END q3 animation set
					
					--escapeEnable = true
					--if (getProgressCancel == true) then
					--exit	-- loop through only 1 animation
	--------------
				end_task = getProgressCancel
	
				) --> end kp animation set

				
				--reset mesh objects to reflect parent [0,0,0]
				if (body_part_f == MODEL_BODY) or ( body_part_f == MODEL_HEAD) or (body_part_f == MODEL_WEPS) then
				(	
					if ( obj_isTag == 0) then -- is mesh
					(
						local mesh_parent_ID = tag_legs_nodeID as integer
						if (body_part_f == MODEL_HEAD) then	(	mesh_parent_ID  = tag_head_nodeID as integer)
						if (body_part_f == MODEL_WEPS) then 	(	mesh_parent_ID  = tag_wep_nodeID as integer)	
						
						for parent_obj in objects do
						(
							if parent_obj.isHidden then continue -- node is hidden, skip
								
							if (parent_obj.inode.handle == mesh_parent_ID) then -- hypo todo self or parent?
							(
								targetObj.parent = parent_obj --tag_body -- todo check wep. head..
								exit
							)
						)
						in coordsys parent targetObj.pos = [0,0,0]
						in coordsys parent targetObj.rotation.x_rotation = 0
						in coordsys parent targetObj.rotation.y_rotation = 0
						in coordsys parent targetObj.rotation.z_rotation = 0
					) --end mesh object origin/target
				)
				
				-- legs to run side step
				if (body_part_f == MODEL_LEGS) and ( obj_isTag == 0) then  -- is legs mesh	
				(		
					--				
					for parent_obj in objects do
					(
						if parent_obj.isHidden then 
							continue -- node is hidden, skip
							
						if (parent_obj.inode.handle == tag_legs_nodeID) then
						(			-- right 131-136 & 159-164 -- left 137-142 & 165-170
							local twistR_timer = #(131, 159)
							local twistL_timer = #(137, 165)	
							local stand_timer = #(0,1,2,130, 143, 158, 171)
							for keyAt in stand_timer do
							(
								animate on (	at time keyAt 	(targetObj.pos = [0, 0, 0]; targetObj.rotation = (EulerAngles 0 0 0); targetObj.scale = [1,1,1]))	
								--at time keyAt targetObj.controller.keys.inTangentType= #step
								--at time keyAt targetObj.controller.keys.outTangentType= #step	
							)	
							for keyAt in twistR_timer do
							(
								animate on (	at time keyAt about parent_obj rotate targetObj  (EulerAngles 0 0 -60))
							--	at time keyAt targetObj.controller.keys.inTangentType= #step
								--at time keyAt targetObj.controller.keys.outTangentType= #step									
							)	
							for keyAt in twistL_timer do
							(
								animate on(at time keyAt about parent_obj rotate targetObj  (EulerAngles 0 0 120))
							)
							targetObj.pos.x_position.controller.keys.inTangentType= #step
							targetObj.pos.x_position.controller.keys.outTangentType= #step
							targetObj.pos.y_position.controller.keys.inTangentType= #step
							targetObj.pos.y_position.controller.keys.outTangentType= #step	
							targetObj.pos.z_position.controller.keys.inTangentType= #step
							targetObj.pos.z_position.controller.keys.outTangentType= #step	
							
							targetObj.rotation.x_rotation.controller.keys.inTangentType= #step
							targetObj.rotation.x_rotation.controller.keys.outTangentType= #step
							targetObj.rotation.y_rotation.controller.keys.inTangentType= #step
							targetObj.rotation.y_rotation.controller.keys.outTangentType= #step						
							targetObj.rotation.z_rotation.controller.keys.inTangentType= #step
							targetObj.rotation.z_rotation.controller.keys.outTangentType= #step	
							
							--targetObj.scale.controller.keys.outTangentType= #step						
							exit
						)
					) --> end find matching object
				) --> end legs run side step
				
				update targetObj
				max views redraw
				print("----------| End Model |----------")
				
				end_task=getProgressCancel()			
			) -- end loop through body parts
		)--end task	
		--print("moving ANIMATION SET keys Done-----")
	) --end function copy keys
	
	
	--move tags to array index 1	
	fn move_tagToTop array_ tag_name=
	(
		local tmpArray=#()
		
		for x=1 to array_.count do
		(
			local objName = array_[x].name as name
			local tagName = tag_name as name
		
			if  objName == tagName then
			(
				swap array_[x] array_[1]
				print("----- tag rename done OK!! -----")
				exit
			)
		)
		print("----- tag rename done     -----")		
	) -- end func move tag to top of list
	
	
	fn setupObjectsAsGroups =	
	(
		array_legs=#()
		array_body=#()
		array_head=#()
		array_wep=#()
	
		for obj in objects do  --geometry
		(
			
			if obj.isHidden then 
				continue -- object hidden, skip
			
			print("adding object= " +	(obj.name as string))
			
			local firstletter = substring obj.name 1 2 as name
			local tagname = 	substring obj.name 1 4 as name
			local parent_tag = undefined
			local objectsName = obj.name as name --string 
	
				
			if obj.parent != undefined then
				parent_tag = obj.parent.name as name --string

			--asigne each part to a group. eg.. tag_torso to group_body	
			if (tagname == "tag_" as name) then
			(
					if (objectsName == "tag_torso" as name) then
					(
						if (parent_tag == undefined) then
							append array_legs obj
						else
							append array_body obj
					)
					else if (objectsName == "tag_head" as name) then 
					(
						if (parent_tag == undefined) then
							print("---- parent error ----")
						else if (parent_tag == "tag_head" as name) then
							append array_head obj 
						else 
							append array_body obj
					)
					else if (objectsName == "tag_weapon" as name) then
					(
						if (parent_tag == undefined) then
							print("---- parent error ----")
						else if (parent_tag == "tag_weapon" as name) then
							append array_wep obj 
						else
							append array_body obj 
					)
					else if (objectsName == "tag_flash" as name) then
						append array_wep obj 
					else
						print("---- parent error ----")					
			)-- end tag asigments
			else if (firstletter == "l_" as name) then
					append array_legs obj 
			else if (firstletter  == "u_" as name) then
					append array_body obj 
			else if (firstletter == "w_" as name) then
					append array_wep obj 
			else if (firstletter == "h_" as name) then
				append array_head obj 	
			else 	
				print("---- error unknown obj=")
				
		) -- end adding each mesh object to array
		

		--move_tagToTop array_legs tag_torso_
		move_tagToTop array_body "tag_torso"
		move_tagToTop array_head "tag_head"
		move_tagToTop array_wep "tag_weapon"
		

		format "array_legs %\n" array_legs
		format "array_body %\n" array_body
		format "array_head %\n" array_head
		format "array_wep  %\n" array_wep
		print("---- Finished Grouping items -----")		
	)--end function set model groups
	
	
	-- inital loading of script... Do
	on QuakeMD3_To_Kingpin open do 
	(		
		-- kingpin multi player model ani set
		append array_kp_Anims (frame_num_KP start:0  	end:31		head:1 wep:1		legs:LEGS_IDLE		body:TORSO_STAND)		--tgun_rdy_			1st frame
		append array_kp_Anims (frame_num_KP start:32	end:36		head:1 wep:1		legs:LEGS_IDLE		body:TORSO_ATTACK)		--tg_shoot_
		append array_kp_Anims (frame_num_KP start:37	end:46		head:1 wep:1		legs:LEGS_IDLE		body:TORSO_GESTURE)	--tg_bird_
		append array_kp_Anims (frame_num_KP start:47	end:62		head:1 wep:1		legs:LEGS_IDLE		body:TORSO_GESTURE)	--tg_crch_grab_
		append array_kp_Anims (frame_num_KP start:63	end:77		head:1 wep:1		legs:LEGS_IDLE		body:TORSO_GESTURE)	--tg_chin_flip_
		append array_kp_Anims (frame_num_KP start:78	end:100		head:1 wep:1		legs:LEGS_IDLE		body:TORSO_STAND)		--1pstl_rdy_			1st frame	body:pistol
		append array_kp_Anims (frame_num_KP start:101	end:104		head:1 wep:1		legs:LEGS_IDLE		body:TORSO_ATTACK)		--p_std_shoot_
		append array_kp_Anims (frame_num_KP start:105	end:114		head:1 wep:1		legs:LEGS_WALK		body:TORSO_STAND)		--walk_gdown_		
		append array_kp_Anims (frame_num_KP start:115	end:124		head:1 wep:1		legs:LEGS_WALK		body:TORSO_ATTACK)		--walk_tg_sht_
		append array_kp_Anims (frame_num_KP start:125	end:130		head:1 wep:1		legs:LEGS_RUN		body:TORSO_ATTACK)		--run_tg_sht_
		append array_kp_Anims (frame_num_KP start:131	end:136		head:1 wep:1		legs:LEGS_RUN		body:TORSO_STAND)		--rsd_tg_run_		
		append array_kp_Anims (frame_num_KP start:137	end:142		head:1 wep:1		legs:LEGS_RUN		body:TORSO_STAND)		--lsd_tg_run_		
		append array_kp_Anims (frame_num_KP start:143	end:152		head:1 wep:1		legs:LEGS_WALK		body:TORSO_ATTACK)		--p_walk_sht_		pistol
		append array_kp_Anims (frame_num_KP start:153	end:158		head:1 wep:1		legs:LEGS_RUN		body:TORSO_ATTACK)		--p_run_shoot_ 		pistol
		append array_kp_Anims (frame_num_KP start:159	end:164		head:1 wep:1		legs:LEGS_RUN		body:TORSO_STAND)		--p_rside_run_ 		*missing* pistol
		append array_kp_Anims (frame_num_KP start:165	end:170		head:1 wep:1		legs:LEGS_RUN		body:TORSO_STAND)		--p_lside_run_ 		*missing* pistol
		append array_kp_Anims (frame_num_KP start:171	end:189		head:1 wep:1		legs:LEGS_IDLE		body:TORSO_STAND2)		--melee_rdy_			1st frame
		append array_kp_Anims (frame_num_KP start:190	end:196		head:1 wep:1		legs:LEGS_IDLE		body:TORSO_ATTACK2)	--melee1_
		append array_kp_Anims (frame_num_KP start:197	end:202		head:1 wep:1		legs:LEGS_IDLE		body:TORSO_ATTACK2)	--melee2_
		append array_kp_Anims (frame_num_KP start:203	end:208		head:1 wep:1		legs:LEGS_RUN		body:TORSO_ATTACK2)	--run_melee_ 		//checkkk
		append array_kp_Anims (frame_num_KP start:209	end:214		head:1 wep:1		legs:LEGS_RUN		body:TORSO_STAND)		--run_gun_dn_	
		append array_kp_Anims (frame_num_KP start:215	end:221		head:1 wep:1		legs:LEGS_JUMP		body:TORSO_STAND)		--jump_				1st frame
		append array_kp_Anims (frame_num_KP start:222	end:230		head:1 wep:1		legs:LEGS_IDLE		body:TORSO_STAND)		--clmb_loop_			*missing*
		append array_kp_Anims (frame_num_KP start:231	end:249		head:1 wep:1		legs:BOTH_DEATH2	body:BOTH_DEATH2)		--death1_				19 frames	--sorted in q3 least to most fps
		append array_kp_Anims (frame_num_KP start:250	end:265		head:1 wep:1		legs:BOTH_DEATH1	body:BOTH_DEATH1)		--death2_				16 frames	--sorted in q3 least to most fps
		append array_kp_Anims (frame_num_KP start:266	end:293		head:1 wep:1		legs:BOTH_DEATH3	body:BOTH_DEATH3)		--death3_				28 frames	--sorted in q3 least to most fps
		append array_kp_Anims (frame_num_KP start:294	end:306		head:1 wep:1		legs:BOTH_DEATH1	body:BOTH_DEATH1)		--death4_				13 frames --duplicate of death2
		append array_kp_Anims (frame_num_KP start:307	end:333		head:1 wep:1		legs:LEGS_IDLECR	body:TORSO_STAND)		--tg_crch_rdy_
		append array_kp_Anims (frame_num_KP start:334	end:339		head:1 wep:1		legs:LEGS_IDLECR	body:TORSO_ATTACK)		--crouch_shoot_	
		append array_kp_Anims (frame_num_KP start:340	end:344		head:1 wep:1		legs:LEGS_WALKCR	body:TORSO_STAND)		--crch_walk_		
		append array_kp_Anims (frame_num_KP start:345	end:362		head:1 wep:1		legs:LEGS_IDLECR	body:TORSO_STAND)		--1p_crch_rdy_		pistol
		append array_kp_Anims (frame_num_KP start:363	end:367		head:1 wep:1		legs:LEGS_IDLECR	body:TORSO_ATTACK)		--p_crch_sht_		pistol
		append array_kp_Anims (frame_num_KP start:368	end:373		head:1 wep:1		legs:LEGS_WALKCR	body:TORSO_ATTACK)		--p_crch_walk_		1st frame, pistol
		append array_kp_Anims (frame_num_KP start:374	end:385		head:1 wep:1		legs:BOTH_DEATH1	body:BOTH_DEATH1)			--crouch_death_		*missing*
	) --end on load script

	-- button get animation.cfg
	on UI_btn_GetFile pressed do
	(
		animationfile=getopenfilename caption:"Open Frame File" filename:"" types:"Quake3 Animation File (animation.cfg)|animation.cfg|All Files|*.*"
		if animationfile != undefined do
		(
			if DoesFileExist animationfile then
			(
				local file = openFile animationfile mode:"r"
				local ani_Index = 0 as integer			
				local lineNum =0		
				local offsetLegsTime = 0 as integer
				
				array_frameFileQ3=#() --free array

				try
				(
					while not EOF file do
					(
						local frameStart, frameEnd, frameFPS					
						local strTmp = readLine file
						local lineDelim = filterString strTmp " \t"
						lineNum += 1
						
						if lineDelim.count < 4 then 
							continue
						
						if (lineDelim[1][1] == "/") or (lineDelim[2][1] == "/") or (lineDelim[4][1] == "/") then
							continue				
						--print ("delimiters= " + (lineDelim[1]as string)+", "+(lineDelim[2]as string)+", "+(lineDelim[3]as string)+", "+(lineDelim[4]as string))			
							
						frameStart = lineDelim[1] as integer
						frameEnd = lineDelim[2] as integer
						frameFPS = lineDelim[4] as integer
						
						if (frameStart == undefined) or	(frameEnd == undefined) or (frameFPS == undefined) then
						(
							print ("line#" + (lineNum as string) +" missing int")								
							continue	
						)							
	
						ani_Index += 1	
						if (ani_Index > LEGS_TURN) then
							print "*** File has to many animations ***"

						if (ani_Index == LEGS_WALKCR) then 
						(
							local offsetLeg = array_frameFileQ3[TORSO_GESTURE].start
							print("leg offset= " +( offsetLeg as string))
							offsetLegsTime = (frameStart - offsetLeg)
						)
						
						--leg animations start at torso start frame #
						if (ani_Index >= LEGS_WALKCR) then 
							frameStart -= offsetLegsTime
						
						append array_frameFileQ3 (frame_num_q3 start:frameStart total_fr:frameEnd fps:frameFPS )
						
						--debug
						--print("anim= "+(ani_Index as string)+" frameStart= "+(frameStart as string)+ " frameEnd= " +(frameEnd as string))
						--print("anim= "+(ani_Index as string)+ " getframe= " +(array_frameFileQ3[ani_Index].start as string))
			
					)
				)
				catch
				(
					format "*** % ***\n" (getCurrentException())
					throw()
				)
			
				close file
			)
			
			--arange death by frame counts
			sortDeathAni_ByFrames_fn 

		)
	) -- end button pressed get animation.cfg file
	
	
	on UI_btn_DoConversion pressed do
	(
		end_task = false
		
		tag_legs_nodeID = undefined
		tag_head_nodeID = undefined
		tag_wep_nodeID = undefined
		
		clearSelection()
		progressStart "Converting..."

		try
		(
			setupObjectsAsGroups()	
			
			if (array_frameFileQ3 !=undefined) and (array_frameFileQ3.count >= 25) then --todo -3 for death
			(
				local completend = ( (array_frameFileQ3[25].start as integer) + ((array_frameFileQ3[25].total_fr as integer) ) ) as integer
				print("completend= " +(completend as string))
				animationrange = interval 0 390
				moveModelKeys_fn 	array_legs 	 	MODEL_LEGS 			
				moveModelKeys_fn 	array_body  	MODEL_BODY	
				moveModelKeys_fn 	array_head   	MODEL_HEAD
				moveModelKeys_fn 	array_wep 	 	MODEL_WEPS
				-- todo: tag flash??
			)
			else
			(
				messagebox "ERROR.. in Animation.cfg"
			)
		)
		catch
		(
			--messageBox "Moving keys issue"
			format "*** % ***\n" getCurrentException()
			throw()
		)
		
		--resumeEditing()
		progressEnd()
		
		max views redraw		
	)-- end button do convert
	
	
)