#ifndef Aztec2_Edit_Mesh_Functions_Header
#define Aztec2_Edit_Mesh_Functions_Header

#include <functions/FunctionManager.h>

#include <MEditableMesh.h>

namespace AztecGUI {

  void registerMeshFunctions(FunctionManager &man);

  /**
   * This class is used to define an edge for use in a mesh function. It 
   * provides a number of comparison operators that considers two edges 
   * equal if they share the two same points, regardless of the order.
   *
   * For example, if there are three edges A=(1,5), B=(5,2), C=(5,1), 
   * edges A and C are considered the same.
   */
  class Edge {
  public:
    Edge() : a(-1), b(-1) { }
    Edge(int aa, int bb) : a(aa), b(bb) { }
    Edge(const Edge &src) : a(src.a), b(src.b), n(src.n) { }

    bool operator==(const Edge &rhs) const {
      return ( (a == rhs.a && b == rhs.b) || (a == rhs.b && b == rhs.a) );
    }

    bool operator!=(const Edge &rhs) const {
      return !((*this) == rhs);
    }

    bool operator<(const Edge &rhs) const {
      int a1, b1;
      int a2, b2;

      if (a < b) {
        a1 = a;
        b1 = b;
      } else {
        a1 = b;
        b1 = a;
      }

      if (rhs.a < rhs.b) {
        a2 = rhs.a;
        b2 = rhs.b;
      } else {
        a2 = rhs.b;
        b2 = rhs.a;
      }

      if (a1 < a2) return true;
      if (a1 > a2) return false;
      
      return b1 < b2;
    };

    int a;
    int b;

    // This is mutable because it isn't used in the comparison at all. Allows 
    // us to change the value of it when this Edge class acts as a key in a 
    // map of some sort.
    mutable int n;
  };


  int flattenComponentsToPlane(const StringVector &args, std::string &result);
  int separateMeshFacets(const StringVector &args, std::string &result);
  int combineMeshes(const StringVector &args, std::string &result);
  int createSubdividedSurface(const StringVector &args, std::string &result);
  int convertToMesh(const StringVector &args, std::string &result);
  int grabFaceUVs(const StringVector &args, std::string &result);
  int weldMeshVertices(const StringVector &args, std::string &result);
  int detachFaces(const StringVector &args, std::string &result);
  int edgeConnect(const StringVector &args, std::string &result);

  /**
   * This performs an edge connect using any selected edges as input to the 
   * edge connect function.
   */
  void edgeConnectMesh(const Aztec::MEditableMeshPtr &mesh, int divisions);

  typedef std::map< Edge, int > EdgeConnectEdges;

  /**
   * This connects all the given edges together, and puts the new vertices 
   * for each operation into the second part of the map.
   */
  void edgeConnectMesh(const Aztec::MEditableMeshPtr &mesh,
                       int divisions,
                       EdgeConnectEdges &inputEdges, 
                       std::vector<Edge> &newEdges);

  int pointConnect(const StringVector &args, std::string &result);
  void pointConnectMesh(const Aztec::MEditableMeshPtr &mesh);
  void pointConnectMesh(const Aztec::MEditableMeshPtr &mesh, int a, int b);
  int faceConnectMesh(const Aztec::MEditableMeshPtr &mesh);
  int faceConnect(const StringVector &args, std::string &result);
  int componentConnect(const StringVector &args, std::string &result);

}



#endif

