#ifndef MEdgeDivideTool_Header
#define MEdgeDivideTool_Header

#include <tools/M3DToolType.h>

// AztecLib includes
#include <MEditableMesh.h>
#include <MSceneObject.h>


namespace AztecGUI {

  class MEdgeDivideTool : public M3DToolType {
  public:
    MEdgeDivideTool();
    
    // MToolType methods
    std::string getName();
    void initialise();
    bool cancel();
    int drawTool(bool select, const Aztec::MComponentPtr &component);
    int onMouseDown(const Aztec::MMouseEvent &event);
    int onMouseMove(const Aztec::MMouseEvent &event);
    int onMouseUp(const Aztec::MMouseEvent &event);

  private:
    Aztec::MSceneObjectPtr selectedObject;
    Aztec::MEditableMeshPtr EdgeMesh;
    int EdgeNum;
    double edgeFrac;

    Aztec::MEditableMeshPtr lastEdgeMesh;
    int lastPointCreated;
    
  };

}
#endif

