#ifndef MGraphInsertKeyTool_Header
#define MGraphInsertKeyTool_Header

#include <tools/MToolType.h>

#include <MFloatKeyList.h>

namespace AztecGUI {

  class MGraphInsertKeyTool : public MToolType
  {

  public:
    MGraphInsertKeyTool();

    // MToolType methods
    std::string getName();
    int drawTool(bool select, const Aztec::MComponentPtr &component);
    int onMouseDown(const Aztec::MMouseEvent &event);
    int onMouseUp(const Aztec::MMouseEvent &event);
    int onMouseMove(const Aztec::MMouseEvent &event);
  
  protected:
    bool m_Dragging;
    int m_DownX, m_DownY;
    int m_CurX, m_CurY;
    int m_UpX, m_UpY;

    Aztec::MFloatKeyListPtr currentKeyList;


    Aztec::MFloatKeyListPtr getKeyListAtMouse(int mouseX, int mouseY);
  };

}

#endif