#include <Aztec3DPCH.h>

#include <functions/FunctionManager.h>

// AztecGUICommon inclides
#include <config/UIConfig.h>

// AztecLib Includes
#include <MSystemManager.h>

namespace AztecGUI {

  FunctionManager::FunctionType* FunctionManager::getFunction(const char *name) {
    FunctionMap::iterator it = funcMap.find(name);

    return (it != funcMap.end()) ? it->second : NULL;
  }

  bool FunctionManager::registerFunction(const char *name, FunctionManager::FunctionType *function, const char *category, const char *friendly) {
    // check to see if the function already exists.
    if (funcMap.find(name) != funcMap.end()) {
      Aztec::MSystemManager::getInstance()->logOutput("Warning: Duplicate function name '%s'", name);
    }
    funcMap[name] = function;

    if (category != NULL && friendly != NULL) {
      AztecGUI::UIConfig::addFriendlyCommand(friendly, std::string("Scene.") + name + "();", category);
    }
    return true;
  }

}

