#include <Aztec3DPCH.h>

// Aztec2 includes
#include <functions/edit/ObjectFunctions.h>
#include <utils/SceneFunctions.h>

// AztecLib includes
#include <MScene.h>


// standard includes
#include <algorithm>
#include <locale>

namespace AztecGUI {

  static Aztec::MShapeObjectPtr doDuplicate(const Aztec::MScenePtr &scene, 
                                            const Aztec::MShapeObjectPtr &object) 
  {
    Aztec::MShapeObjectPtr shape = AZTEC_CAST(Aztec::MShapeObject, object->createNew());

    scene->addObject(shape);
    return shape;
  }

  static Aztec::MSceneObjectPtr doDuplicate(const Aztec::MScenePtr &scene, 
                                            const Aztec::MSceneObjectPtr &object) 
  {
    // make a new scene object.
    Aztec::MShapeObjectPtr shape = doDuplicate(scene, object->getShapeObject());

    Aztec::MSceneObjectPtr newObject = AZTEC_CAST(Aztec::MSceneObject, object->createNew());
    newObject->setShapeObject(shape);
    scene->addObject(newObject);

    newObject->setName(object->getName());
    return newObject;
  }

  static void duplicateObject(const Aztec::MScenePtr &scene, 
                              const Aztec::MTreeObjectNodePtr &node) 
  {
    Aztec::MSceneObjectPtr object = AZTEC_CAST(Aztec::MSceneObject, node->getObject());

    if (object == NULL) {
      return;
    }

    scene->selectObject(object, false);
    Aztec::MSceneObjectPtr newObject = doDuplicate(scene, object);
    scene->selectObject(newObject, true);
  }

  int duplicate(const StringVector &args, std::string &result) {
    applyToObjects(Aztec::MScene::getGlobalScene(), 
                   Aztec::MScene::getGlobalScene()->getObjectList(), 
                   ifSelectedCriteria, 
                   duplicateObject);

    return FunctionManager::SUCCEED;
  }

}

