#include <Aztec3DPCH.h>

// Aztec2 includes
#include <functions/FunctionManager.h>
#include <views/AztecViewManager.h>

// AztecLib includes
#include <MSystemManager.h>
#include <MUIManager.h>
#include <MEditableMesh.h>

// Standard includes

namespace AztecGUI {

  int createSubdividedSurface(const StringVector &args, std::string &result) {
    // attempt to create a subdivided object for each of the selected objects.
    Aztec::MBaseObjectPtr obj;
    Aztec::MSceneObjectPtr sceneObj;
    Aztec::MScenePtr scene = Aztec::MScene::getGlobalScene();
    
    scene->getObjectList()->beginIteration();
    
    while (( obj = scene->getObjectList()->getNext() ) != NULL ) {
      sceneObj = AZTEC_CAST(Aztec::MSceneObject, obj);
      if (sceneObj == NULL || !obj->isFlagged(OBJECTFLAG_SELECTED)) {
        continue;
      }
      
      Aztec::MTreeObjectNodePtr objNode = scene->getObjectList()->getCurrentNode();
      Aztec::MMeshModifierPtr meshModifier;
      
      meshModifier = AZTEC_CAST(Aztec::MMeshModifier, Aztec::MSystemManager::getInstance()->getPluginManager()->createObjectFromDefault("MPrimitiveSubdiv"));
      
      // if we couldn't make the sub divided object, quit.
      if (meshModifier == NULL) {
        Aztec::MSystemManager::getInstance()->logOutput("Could not create a Subdivided object, the Primtive Class couldn't be found.");
        scene->getObjectList()->endIteration();
        return FunctionManager::FAIL;
      }
      
      // make the old object wire frame only
      sceneObj->setParamByName("drawWire", "yes");
      
      Aztec::MShapeObjectPtr shapeObj = new Aztec::MMeshShape();
      Aztec::MSceneObjectPtr newSceneObj = new Aztec::MSceneObject();
      shapeObj->setName(sceneObj->getName() + "Shape");
      newSceneObj->setName(sceneObj->getName() + "Subdiv");
      newSceneObj->setShapeObject(shapeObj);
      meshModifier->setName(sceneObj->getName() + "SubdivCreator");
      
      meshModifier->getInputParameter()->setInputParameter(sceneObj->findParameter("shape"));
      shapeObj->findParameter("inMesh")->setInputParameter(meshModifier->getOutputParameter());
      
      scene->addObject(newSceneObj, objNode);
      scene->addObject(meshModifier);
      
      scene->selectNone();
      scene->selectObject(sceneObj);
      
    }
    scene->getObjectList()->endIteration();
    
    AztecViewManager::redrawAllViews();
    return FunctionManager::SUCCEED;
  }


}

