#ifndef AztecGUICommon_MColour_Header
#define AztecGUICommon_MColour_Header

#include <AztecGUICommon.h>

namespace Aztec {

  class AZTECGUI_EXPORT MColour {
  public:
    MColour();
    MColour(const MColour &src);
    MColour(float red, float green, float blue, float alpha = 1.0f);
    MColour(double red, double green, double blue, double alpha = 1.0);

    float r;
    float g;
    float b;
    float a;

    unsigned char getRuchar() const;
    unsigned char getGuchar() const;
    unsigned char getBuchar() const;

    unsigned short getRushort() const;
    unsigned short getGushort() const;
    unsigned short getBushort() const;

    bool operator==(const MColour &rhs) const;
    bool operator!=(const MColour &rhs) const;
    MColour operator+(const MColour &rhs) const;
    MColour operator*(float rhs) const;
  };

  Aztec::MColour operator*(float lhs, Aztec::MColour &rhs);
}

Aztec::MColour operator*(float lhs, Aztec::MColour &rhs);


#endif

