#ifndef Aztec_GUICommon_MScrolledContainer_Header
#define Aztec_GUICommon_MScrolledContainer_Header

#include <MRefCountedPtr.h>

namespace Aztec {

  class IMScrolledContainer;
  class MScrolledContainer;

  typedef MRefCountedPtr<IMScrolledContainer> IMScrolledContainerPtr;
  typedef MRefCountedPtr<MScrolledContainer> MScrolledContainerPtr;

}

#include <gui/MContainer.h>

#include <string>


namespace Aztec {

  class AZTECGUI_EXPORT IMScrolledContainer : public virtual IMContainer {
  protected:
    IMScrolledContainer() { }
    ~IMScrolledContainer() { }

  public:
    typedef IMScrolledContainerPtr Ptr;

    typedef enum { VerticalScroller, HorizontalScroller } ScrollBarEnum;
    typedef enum { Always, Automatic, Never } VisiblityEnum;

    virtual void setVisibility(ScrollBarEnum scroller, VisiblityEnum visibility) = 0;
    virtual VisiblityEnum getVisibility(ScrollBarEnum scroller) = 0;

    virtual bool onScrolled(ScrollBarEnum scroller) = 0;
  };

}


/**
 * The following header is included via the AZTEC_GUI
 * variable that should be defined for each platform
 * and used to specify an include directory
 * (ie. ../AztecGUICommon/include/gui/$(AZTEC_GUI)
 * when compiling this lib
 */
#include <MScrolledContainerImpl.h>


#endif

