
#ifndef MMenuImpl_Header
#define MMenuImpl_Header

#include "MRefCountedPtr.h"

namespace Aztec {

  class MMenu;
  typedef MRefCountedPtr<MMenu> MMenuPtr;

}


#include <gui/MMenu.h>
#include <gui/qt3/MMenuItemImpl.h>

#include <map>
#include <vector>

#include <qpopupmenu.h>


namespace Aztec {

  class AZTECGUI_EXPORT MMenu : public virtual Aztec::IMMenu, public Aztec::MMenuShell {
  public:
    MMenu();
    ~MMenu();

    bool init();

    // MMenu Methods
    int getItemCount();
    MMenuItemPtr getItem(int index);
    void addItem(MMenuItemPtr item);
    void addItem(MMenuItemPtr item, int index);
    void addSeparator();
    void addSeparator(int index);
    void removeItem(int index);
    bool onItemClick(const MMenuItemPtr &item);
    bool popupMenu(const MComponentPtr &component, const MPoint2D &position);

  protected:
    //std::vector<MMenuItemPtr> m_Items;
    std::map<int, MMenuItemPtr> m_Items;

  public:
    /**
     * Index ID, used for setting the menu item name
     * (yes, it's a dirty hack.. but there's no other way)
     */
    int m_indexID;
  };

}


#endif

