
#ifndef QContainer_Header
#define QContainer_Header

#include <string>
#include <iostream>

#include <qwidget.h>

#include "gui/MContainer.h"
#include "gui/qt3/MAppImpl.h"


Aztec::MShiftState getShiftThingie(QMouseEvent* ev, bool released=false) {
  // We need to remember the shift state so we're not
  // deleting this var when stepping out of this function.
  // We're doing this because the Qt mouse stuff is weird
  // (see QMouseEvent documentation for more).
  static Aztec::MShiftState shift(false, false, false, false, false, false);

  shift.ctrlPressed = (ev->state() & Qt::ControlButton) != 0;
  shift.shiftPressed = (ev->state() & Qt::ShiftButton) != 0;
  shift.altPressed = (ev->state() & Qt::AltButton) != 0;

  if (!released) {
    if (!(ev->button() == Qt::NoButton)) {
    shift.leftMouseDown = (ev->button() == Qt::LeftButton);
    shift.rightMouseDown = (ev->button() == Qt::RightButton);
    shift.middleMouseDown = (ev->button() == Qt::MidButton);
    }
  }
  else {
    shift.leftMouseDown = (ev->button() != Qt::LeftButton);
    shift.rightMouseDown = (ev->button() != Qt::RightButton);
    shift.middleMouseDown = (ev->button() != Qt::MidButton);
  }

  if (released) {
    shift.leftMouseDown = false;
    shift.rightMouseDown = false;
    shift.middleMouseDown = false;
  }

  return shift;
};


/**
 * Custom QWidget class for passing signals into AztecGUI
 */
class CQContainer_ : public QWidget {

  // Qt MOC pre-processor macro
  Q_OBJECT

public:
  CQContainer_(QWidget* parent, const Aztec::MContainerPtr ref)
    : QWidget(parent, 0, WRepaintNoErase|WResizeNoErase),
      m_Ref(ref) {
    // Don't clear the background of this widget when
    // receiving a paint signal.
    //setBackgroundMode(Qt::NoBackground);

    // Connect the signals
    connect(this, SIGNAL(resizeEvent(QResizeEvent*)), SLOT(onResize(QResizeEvent*)));
    connect(this, SIGNAL(showEvent(QShowEvent*)), SLOT(onShow(QShowEvent*)));
    connect(this, SIGNAL(paintEvent(QPaintEvent*)), SLOT(onPaint(QPaintEvent*)));
    connect(this, SIGNAL(mousePressEvent(QMouseEvent*)), SLOT(onMousePress(QMouseEvent*)));
    connect(this, SIGNAL(mouseReleaseEvent(QMouseEvent*)), SLOT(onMouseRelease(QMouseEvent*)));
    connect(this, SIGNAL(mouseMoveEvent(QMouseEvent*)), SLOT(onMouseMove(QMouseEvent*)));
    connect(this, SIGNAL(keyPressEvent(QKeyEvent*)), SLOT(onKeyPress(QKeyEvent*)));
    connect(this, SIGNAL(keyReleaseEvent(QKeyEvent*)), SLOT(onKeyRelease(QKeyEvent*)));

    // To receive key presses we should be able to focus on the widget
    setFocusPolicy(QWidget::StrongFocus);
  };

  ~CQContainer_() {
    m_Ref = 0l;
  }

protected:
  /**
   * A reference to the MContainer that is using us
   */
  Aztec::MContainerPtr m_Ref;

signals:
  /**
   * Qt signals
   */
  void resizeEvent(QResizeEvent* ev);
  void showEvent(QShowEvent* ev);
  void paintEvent(QPaintEvent* ev);
  void mousePressEvent(QMouseEvent* ev);
  void mouseReleaseEvent(QMouseEvent* ev);
  void mouseMoveEvent(QMouseEvent* ev);
  void keyPressEvent(QKeyEvent* ev);
  void keyReleaseEvent(QKeyEvent* ev);

protected slots:
  /**
   * These methods passes the signals to AztecGUI
   */
  void onResize(QResizeEvent* ev) {
    QWidget::resizeEvent(ev);
    m_Ref->onResize(ev->size().width(), ev->size().height());
  };

  void onShow(QShowEvent* ev) {
    QWidget::showEvent(ev);
    lower();
    m_Ref->onShow();
  };

  void onPaint(QPaintEvent* ev) {
    QWidget::paintEvent(ev);
    m_Ref->onPaint();
  }

  void onMousePress(QMouseEvent* ev) {
    //QWidget::mousePressEvent(ev);

    Aztec::MShiftState state = getShiftThingie(ev);
    Aztec::MMouseEvent event(Aztec::MMouseEvent::MBUTTON_DOWN, 0,
                             Aztec::MPoint2D(ev->x(), ev->y()), state, m_Ref);

    /**
     * TODO: Add some additional methods to MShiftState
     *       so we can remove the ugly if-else building below
     *       and use something like the following code instead.
     *
     * Aztec::MMouseEvent event(state.getType(), // or so..
     *                          0, Aztec::MPoint2D(ev->x(), ev->y()), state, m_Ref);
     */

    // TODO: Take care of time value (?)
    if (state.leftMouseDown) {
      event = Aztec::MMouseEvent(Aztec::MMouseEvent::LBUTTON_DOWN, 0,
                                 Aztec::MPoint2D(ev->x(), ev->y()), state, m_Ref);
    }
    else if (state.rightMouseDown) {
      event = Aztec::MMouseEvent(Aztec::MMouseEvent::RBUTTON_DOWN, 0,
                                 Aztec::MPoint2D(ev->x(), ev->y()), state, m_Ref);
    }
    else if (state.middleMouseDown) {
      event = Aztec::MMouseEvent(Aztec::MMouseEvent::MBUTTON_DOWN, 0,
                                 Aztec::MPoint2D(ev->x(), ev->y()), state, m_Ref);
    }

    // Fire off all AGUI handlers
    bool handled = Aztec::MApp::getInstance()->onMousePressed(event);

    m_Ref->fireMouseListeners(event);

    if (!handled) m_Ref->onMousePressed(event);
    else ev->ignore();
  };

  void onMouseRelease(QMouseEvent* ev) {
    //QWidget::mouseReleaseEvent(ev);

    Aztec::MShiftState state = getShiftThingie(ev, true);
    Aztec::MMouseEvent event(Aztec::MMouseEvent::MBUTTON_UP, 0,
                             Aztec::MPoint2D(ev->x(), ev->y()), state, m_Ref);

    // TODO: Take care of time value (?)
    if (!state.leftMouseDown) {
      event = Aztec::MMouseEvent(Aztec::MMouseEvent::LBUTTON_UP, 0,
                                 Aztec::MPoint2D(ev->x(), ev->y()), state, m_Ref);
    }
    else if (!state.rightMouseDown) {
      event = Aztec::MMouseEvent(Aztec::MMouseEvent::RBUTTON_UP, 0,
                                 Aztec::MPoint2D(ev->x(), ev->y()), state, m_Ref);
    }
    else if (!state.middleMouseDown) {
      event = Aztec::MMouseEvent(Aztec::MMouseEvent::MBUTTON_UP, 0,
                                 Aztec::MPoint2D(ev->x(), ev->y()), state, m_Ref);
    }

    // Fire off all AGUI handlers
    bool handled = Aztec::MApp::getInstance()->onMouseReleased(event);

    m_Ref->fireMouseListeners(event);

    if (!handled) m_Ref->onMouseReleased(event);
    else ev->ignore();
  };

  void onMouseMove(QMouseEvent* ev) {
    //QWidget::mouseMoveEvent(ev);

    // TODO: See onMousePress()
    Aztec::MMouseEvent event(Aztec::MMouseEvent::MOVE,
                             0, Aztec::MPoint2D(ev->x(), ev->y()),
                             getShiftThingie(ev), m_Ref);

    // Fire off the AGUI handler
    m_Ref->onMouseMove(event);
  };

  void onKeyPress(QKeyEvent* ev) {
    std::cout << "MContainer::onKeyPress" << std::endl;

    // Move the event back up to the other widgets
    ev->ignore();
  }

  void onKeyRelease(QKeyEvent* ev) {
    std::cout << "MContainer::onKeyRelease" << std::endl;

    // Move the event back up to the other widgets
    ev->ignore();
  }

};


#endif

