
#ifndef QScrolledContainer_Header
#define QScrolledContainer_Header

#include <string>
#include <iostream>

#include <qscrollview.h>

#include "gui/MScrolledContainer.h"


/**
 * Custom QScrollView class for passing signals into AztecGUI
 */
class CQScrolledContainer_ : public QScrollView {

  // Qt MOC pre-processor macro
  Q_OBJECT

public:
  CQScrolledContainer_(QWidget* parent, const Aztec::MScrolledContainerPtr ref)
    : QScrollView(parent),
      m_Ref(ref) {
    // Connect the signals
    //connect(this, SIGNAL(resizeEvent(QResizeEvent*)), SLOT(onResize(QResizeEvent*)));
    connect(this, SIGNAL(showEvent(QShowEvent*)), SLOT(onShow(QShowEvent*)));

    /**
     * Because the amount of widgets can exceed the amount of pixels (height)
     * we can reliably use when using XFree86 we're enabling the clipper here.
    */
    enableClipper(true);
  };

  ~CQScrolledContainer_() {
    m_Ref = 0l;
  }

protected:
  /**
   * A reference to the MScrolledContainer that is using us
   */
  Aztec::MScrolledContainerPtr m_Ref;

signals:
  /**
   * Qt signals
   */
  //void resizeEvent(QResizeEvent* ev);
  void showEvent(QShowEvent* ev);

protected slots:
  /**
   * These methods passes the signals to AztecGUI
   */
  /*void onResize(QResizeEvent* ev) {
    QScrollView::resizeEvent(ev);
    m_Ref->onResize(ev->size().width(), ev->size().height());
  };*/

  void onShow(QShowEvent* ev) {
    QScrollView::showEvent(ev);
    m_Ref->onShow();
  };

};


#endif

