#ifndef MCheckboxImpl_Header
#define MCheckboxImpl_Header

#include <gui/MCheckbox.h>
#include <gui/win32/MComponentImpl.h>

#include <string>


namespace Aztec {

  class AZTECGUI_EXPORT MCheckbox : public virtual Aztec::IMCheckbox, public MComponent {
  public:

    MCheckbox(bool value);
    ~MCheckbox();

    // MComponentImpl methods
    bool createImpl();
    bool wndProc(UINT message, WPARAM wParam, LPARAM lParam, LRESULT *result);

    // MCheckbox Methods
    void setValue(bool value);
    bool getValue();

    bool onChanged();
    void addListener(const ChangeListenerPtr &listener);

    // MComponent methods
    bool isMinimumSizeSet();
    MSize2D getMinimumSize();


  protected:

    /// The minimum size of the text
    MSize2D minSize;

    /// the starting minimum and maximum values
    bool startValue;

    std::vector<ChangeListenerPtr> listeners;
  };

}


#endif