#include <AztecGUICommonPCH.h>

#include <gui/win32/MToolWindowImpl.h>
#include <gui/win32/MAppImpl.h>

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  MToolWindow::MToolWindow(const std::string &title, const MWindowPtr &parent) 
    : MWindow(title)
  {
    if (parent == NULL) {
      this->parentWindow = Aztec::MApp::getInstance()->getTopLevelWindow();
    } else {
      this->parentWindow = parent;
    }
  }

  MToolWindow::~MToolWindow() {
  }

  bool MToolWindow::createImpl() {
    return doCreateImpl(WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN, WS_EX_TOOLWINDOW, parentWindow);
  }

}
