#if !defined( KEYVAL_H )
#define KEYVAL_H

typedef union {
	int		bval;	// Boolean value (C doesn't have bool by default)
	int		ival;	// Integer value
	double	dval;	// Floating point value
	char	*sval;	// id/string value
} CValueType;

#define KEYVAL_TYPE_UNKNOWN		0
#define KEYVAL_TYPE_INTEGER		1
#define KEYVAL_TYPE_FLOAT		2
#define KEYVAL_TYPE_BOOLEAN		3
#define KEYVAL_TYPE_STRING		4

// Determine the type of a null-terminated string.  Returns one of the above

#ifdef WIN32

#if !defined( MGENEXPORT )
#ifdef _MGENBUILD
#define MGENEXPORT __declspec(dllexport)
#else
#define MGENEXPORT __declspec(dllimport)
#endif
#else
#endif

#else

// For gcc
#define MGENEXPORT

#endif


#if defined( __cplusplus )
extern "C" {
#endif

	int MGENEXPORT getValueType(const char *str, CValueType *val);

#if defined( __cplusplus )
}
#endif

#endif // KEYVAL_H
